#ifndef __LUBAN_SYMBOLRESOLVER_HPP__
#define __LUBAN_SYMBOLRESOLVER_HPP__

#include <string>
#include <iosfwd>

namespace Luban
{
  class LubanCodeRepository;
  class LBTypeSpec;
  class LBFullSymbol;
  class LBComponentInfo;
  class TreeNode;
  class LBStruct;
  class LBStructInterface;

  using std::string;

  class LubanSymbolResolver
  {
  public:

    static bool addSymbol(const LBFullSymbol& fullname, TreeNode* ptree, string& errs);
    static bool addOrReplaceSymbol(const LBFullSymbol& fullname, TreeNode* ptree, string& errs);

    static bool addImportedType(const LBFullSymbol& fullname, string& errs);
    
    static LBStruct* resolveStructSymbol(const LBFullSymbol& s, string& errs); // pointer to internal data, not a copy
    static const LBTypeSpec* resolveTypeSymbol(const LBFullSymbol& s, string& errs);
    static const LBStructInterface* resolveStructInterface(const LBFullSymbol& s, string& errs);

    static bool instantiateSymbol(const LBFullSymbol& sym, string& errs);
    static bool hasSymbol(const LBFullSymbol& sym);

    static ostream& printSymbol(const LBFullSymbol& sym, ostream& ost);

    static bool saveSymbolToRepository(const LBFullSymbol& s, string& errs);

    // admin function
    static void setRepository(LubanCodeRepository* m);

  private:

    static bool addSymbol(const LBFullSymbol& fullname, LBComponentInfo* s, string& errs);
    static bool addOrReplaceSymbol(const LBFullSymbol& fullname, LBComponentInfo* s, string& errs);

    // this function will try both name space and repository and do the loading if necessary
    // but it won't do resolving
    static LBComponentInfo* findOrLoadSymbol(const LBFullSymbol& s, string& errs); 

    
    static bool instantiate(LBComponentInfo *comp, string& errs);


    // the way to avoid infinite loop is to use the following function to resolve all
    // the external type symbols and their refered type symbols
    // and let the code generator not to do any recursion, it stops and report error
    // if the LCG type expression parser encounter any unresolved type symbol
    // This design require a seperated function in LCG to give the list of external
    // symbols for resolving. And the external symbol list should be persisted

    static bool resolveTypeOrInterface(LBComponentInfo *comp, string& errs); // this is the entrance of single threaded functions
    static bool resolveTypeDefSingleThread(LBComponentInfo *comp, string& errs);
    static bool resolveInterfaceSingleThread(LBComponentInfo *comp, string& errs);
    static bool resolveTypeOrInterfaceSingleThread(const LBFullSymbol& name, string& errs);
    static bool resolveTypeOrInterfaceSingleThread(LBComponentInfo* comp, string& errs);

  };    


}

#endif
