
#include <iostream>
#include <string>
#include "luban_parsetree.hpp"
#include "lbtypes/lbsymbol.hpp"
#include "lbtypes/lbobject.hpp"
#include "lbtypes/lbexception.hpp"

static char *nodeTypeNames[] = 
  {"INVALID", "ONESOURCEUNIT", "NOOP",  "NAMENODE", "FULLNAME", 
   "NAMESPACESPEC", "COMPONENTDEFLIST", "ABSTRACTSTRUCT",
   "PROCESSSTRUCT", "COMPOSITIONSTRUCT", "STATIONARYSTRUCTDECLARE", "STATIONARYSTITEMLIST", "TYPENAMEDEF", "ONETYPENAMES", "NAMELIST",
   "DOUBLE", "INT", "STRING", "BOOL", "CHAR", "STRUCT", "VECTOR", "MAP", "SET","RANGE", "TYPENAME",
   "SYNCHSTRUCT", "ASYNCHSTRUCT", "IN", "OUT", "STATIC", "STORE", 
   "READONLY", "HIDDEN", "READWRITE",
   "TYPENAMELIST", "PROPERTYLIST", "SCOPE_EXECATTR_DEC", "ONETYPEPROPERTIES", 
   "PRCPROPERTYLISTITEM", "PRCSTATEMENTLIST", "PRCSTATEMENT", "SEQUENTIAL", "DISPATCH", "DISPATCHABLE","PRPBATCHSET", 
   "IFST", "IFELSEST", "WHILEST", "FOREACHST", "FORST", "CONTINUEST", "BREAKST", "FINISHST", 
   "ASSIGNOP", "ADDASSIGNOP", "SUBASSIGNOP", "MULASSIGNOP", "DIVASSIGNOP", "MODASSIGNOP", "REGASSIGN",
   "WAITST", "WAITFORST", "CANCELST", "CLOSURE_PRC", "CLOSURE_COMP", "TYPED_VAR_INIT", "VAR_INIT_LIST", "VAR_INIT_ITEM", 
   "PROPERTY", "VAR_EXP", "LITERAL", "VECTOR_CONSTRU", 
   "CONDEXP", "ADD", "SUB", "MUL", "DIV", "MOD", "NEGSIGN", "PLUSSIGN", "NOTSIGN", "PREINC", "PREDEC", "POSTINC", "POSTDEC", 
   "EXPRESSIONLIST", "NONASSIGNEXPLIST", "EXPRESSION", "MAP_CONSTRU", "KEYVALUELIST", "KEYVALUEPAIR", "SET_CONSTRU", 
   "MBRFUNC","STRUCTTYPEEVAL", "STRUCTOBJEVAL", "CONSTR", "SUBSCRIPT", 
   "ANDOP", "OROP", "NOTOP", "EQOP", "GTOP", "LTOP", "GEOP", "LEOP", "NEOP", 
   "NAMEDARGLIST", "NAMEDARG", "INARG", "SWAPARGOP",
   "COMPCELLLIST", "CELL","ASYNCHCELL", "COMPOUNDCELL", "STRUCT_INSTANCE", "TYPEEXPLIST", "TYPEEXPRESSION", "MULTITYPE", 
   "STRUCT_DECLARATION", "PRCCOLLECTOUTPUT", "STRUCTCLASSINS",
   "COMPCOLLECTOUTPUT", "ENUMTYPE", "LITERALLIST", "NAMEDVITEM", "NAMEDVLIST",
   "ISAOP", "TYPEOFOP", "TYPEINFOTYPE", "ALLINSOFTHIS", "ERRORTYPE", "CASTOP",
   "PARENTHESISEXP", "VARLIST", "LOCALVAR", "GLOBALVAR", "INPROPERTYREF", "OUTPROPERTYREF", "STOREPROPERTYREF",
   "STATICPROPERTYREF", "COMPOUTPUT",
   "CLNPASSVECARGPAR", "PASSVECARGPAR", "TYPESPEC",
   "VECOP", "VECOPPAR", "EXPCELL",
   "STATIONARYSTPROPERTIES", "STATIONARYSTPROPERTIES_ST", "COMPOUNDST", "COMPOUNDSTPAR","STATIONARY_STRUCT_DEC"  };


namespace Luban
{
  using std::string;

  void TreeNode::printTree(ostream& s, int level) const
  {
    for ( int j = 0; j < level; j++ )
      s << "   ";
    s << nodeTypeNames[ int(nodeType()) ];
    if ( isLeaf() )
      if ( _obj )
	s << " " << *_obj;
      else
	if ( nodeType() == LITERAL )
	  s << " null";

    s<< "\n";

    for( int i = 0; i < numChildren(); i++)
      if ( _children[i] )
	_children[i]->printTree( s ,level+1);

  }

  void TreeNode::toStream(ostream& ost) const
  {
    ost << int(nodeType()) << ' ' << numChildren() << ' ';
    if ( _obj )
      {
	ost << "1 ";
	LBObject::instanceToStream(ost, *_obj);
      }
    else
	ost << "0 ";

    for(int i=0; i<numChildren(); i++)
      if ( _children[i] )
	{
	  ost << "1 ";
	  _children[i]->toStream(ost);
	}
      else
	ost << "0 ";
  }

  void TreeNode::fromStream(istream& ist)
  {
    int ntype=-1, numc=-1;
    char dummy;
    ist >> ntype;
    ist.get(dummy);
    ist >> numc;
    ist.get(dummy);
    if ( ! ist || dummy != ' ' || ntype == -1 || numc == -1 )
      throw LBException("Corrupted stream, can not recover parse tree from stream\n");
    char objsign;
    ist.get(objsign);
    ist.get(dummy);
    if ( ! ( ( objsign == '1' || objsign == '0')  && dummy == ' ' ) )
      throw LBException("Corrupted stream, can not recover parse tree from stream\n");

    LBObject *obj=0;    
    if ( objsign == '1' )
      {
	string errmsg;
	obj = LBObject::instanceFromStream(ist, errmsg);
	if ( ! obj )
	  throw LBException("Corrupted stream, can not recover data object of a parse tree node error:"+errmsg);
      }

    _nodetype = (NodeType)ntype;
    _numChildren =numc;
    _obj = obj;
    
    if ( numc > 0 )
      {
	_children = new Tree[numc];
	int i=0;
	for(; i < numc ; i++) _children[i] = 0;
	for( i = 0; i < numc; i++)
	  {
	    char chdsign;
	    ist.get(chdsign);
	    ist.get(dummy);
	    if ( ! ( ( chdsign == '1' || chdsign == '0')  && dummy == ' ' ) )
	      throw LBException("Corrupted stream, can not recover parse tree from stream\n");
	    if ( chdsign == '1' )
	      {
		Tree chd = new TreeNode();
		chd->_parent = this;
		chd->fromStream(ist);
		_children[i] = chd;
	      }
	  }
      }
  }

}
