#include "lbtypes/lbsymbol.hpp"
#include <iostream>
#include <string>
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/lbobject.hpp"
#include <stdlib.h>

// 
// Performance of LBSymbol:
//    create 1 Million symbol in 3 seconds on Pentium 1.7Ghz 
//           using 75M memory
//    compare/assign 1M symbols in negeligble time
//    On Linux, there is no noticeable performance difference after adding a
//    mutex lock to make symbol creation thread safe.
//

using std::string;

static string getString(int d)
{
  int digi = (rand() % d ) + 1;

  string s;
  for( int i = 0; i < digi; i++ )
    s += char( 46 + rand() % 75 + 1);

  return s;
}

int main(int argc, char *argv[])
{
  using std::string;
  using Luban::LBSymbol;

  int numdigits = atoi(argv[1]);
  int numsymbols = atoi(argv[2]);

  LBSymbol plbs;
  for( int i = 0; i < numsymbols; i++ )
    {
      string randomstr = getString(numdigits);
       LBSymbol s = LBSymbol(randomstr);

       if ( s == plbs )
 	std::cout << s.toString() << " and " << plbs.toString() << " are the same symbol\n";	

       plbs = s;

      // std::cout << s.toString() << "\n";
    }

  return 0;
}
