#include <iostream>
#include <vector>

#include "lbtypes/lbtypespecmultitype.hpp"
#include "lbtypes/LBDefineMacros.hpp"


namespace Luban
{
  using std::string;
  using std::vector;

  LBDEFINE(Luban::LBTypeSpecMultiType, 1,0)
  LBDEFAULT_STATIC_CONSTRUCTOR(Luban::LBTypeSpecMultiType)

  LBTypeSpecMultiType::LBTypeSpecMultiTypeImp::~LBTypeSpecMultiTypeImp()
  {
    for( int i = 0; i < _typespecvec.size(); i++)
      delete _typespecvec[i];
  }

  LBTypeSpecMultiType::LBTypeSpecMultiType() : _imp(defaultGuts())
  {
  }

  LBTypeSpecMultiType::~LBTypeSpecMultiType()
  {
  }

  string LBTypeSpecMultiType::toString() const
  {
    string s("<");
    for( int i = 0; i < _imp->_typespecvec.size();  i++ )
      {
	if ( i )
	  s += ',';
	s += _imp->_typespecvec[i]->toString();
      }
    s += '>';
    return s;
  }

  ostream& LBTypeSpecMultiType::toStream( ostream& ost) const
  {
    int sz = size();
    ost << sz;
    ost.put(' ');
    
    for( int i = 0; i<sz; i++)
      LBObject::instanceToStream(ost, *_imp->_typespecvec[i]);
    
    return ost;
  }

  istream& LBTypeSpecMultiType::fromStream( istream& ist, int major, int minor)
  {
    int sz = -1;
    ist >> sz;
    char sp = ist.get();
    if ( !ist || sp != ' ' || sz<0 )
      throw LBException("Corrupted stream, can not get the size of LBTypeSpecMultiType");
    
    LBTypeSpecMultiTypeImp *newimp = new LBTypeSpecMultiTypeImp();
    newimp->_typespecvec.reserve(sz);
    string errs;
    for( int i = 0; i<sz; i++)
      {
	LBObject *obj = instanceFromStream(ist, errs);
	if ( obj == 0 )
	  {
	    delete newimp;
	    throw LBException("Failed to get element for LBTypeSpecMultiType: "+string(errs));
	  }
	LBTypeSpec *tpsp = dynamic_cast<LBTypeSpec*>(obj);
	if ( tpsp )
	  newimp->_typespecvec.push_back(tpsp);
	else
	  {
	    delete newimp;
	    throw LBException("Element for LBTypeSpecMultiType is not a LBTypeSpec: "+string(errs));
	  }
      }
    _imp = LBTypeSpecMultiTypeImpPtr(newimp);

    return ist;
  }

  LBDEFAULT_EQUALS_FUNC( Luban::LBTypeSpecMultiType )

  int LBTypeSpecMultiType::size() const
  {
    return _imp->_typespecvec.size();
  }

  bool LBTypeSpecMultiType::checkObj(const LBObject& obj) const
  {
    int sz = size();
    if ( sz==0 ) return true;
    for( int i=0; i<sz; i++ )
      if ( _imp->_typespecvec[i]->checkObj(obj) )
	return true;
    return false;
  }

  void  LBTypeSpecMultiType::addType( LBTypeSpec *tpsp )
  {
    unicopy(_imp);
    _imp->_typespecvec.push_back(tpsp);
  }

  bool  LBTypeSpecMultiType::operator==(const  LBTypeSpecMultiType& mt) const
  { return _imp == mt._imp; }

}
