#ifndef __LBNULL_HPP__
#define __LBNULL_HPP__

#include <string>
#include <iosfwd>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

namespace Luban
{
  using std::string;

  class LBNull : public LBObject
  {
    LBDECLARE( Luban::LBNull )
    
    // constructors
    LBNull() {}

    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    bool equals(const LBObject& another) const;  

    // LBObject optional interfaces
    bool before(const LBObject& x) const;

    // LBNull specific interfaces
    bool operator==(const LBNull& x) const
    { return true; }
    bool operator!=(const LBNull& x) const
    { return false; }
    bool operator<(const LBNull& x) const
    { return false; }

  private:

  };

}


#endif
