#include <string>
#include <sstream>
#include <typeinfo>
#include "lbtypes/lbdouble.hpp"
#include "lbtypes/lbint.hpp"
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbvarargs.hpp"


namespace Luban
{
  using std::string;
  using std::ostringstream;
  using std::istringstream;

  LBDEFINE(Luban::LBInt, 1, 0 )

  LBInt* LBInt::staticConstructor(const LBVarArgs* args)
  {
    // default constructor, required
    if ( args == 0 || args->numArgs() == 0 )
      return new LBInt();
    
    switch ( args->numArgs() ) {
    case 1:
      {
	const LBObject* arg0 = args->getArg(0);
	if ( arg0 == 0 )
	  return 0;

	// copy constructor
	const LBInt *iptr = dynamic_cast<const LBInt*>(arg0);
	if ( iptr )
	  return new LBInt(*iptr);

	// int can be constructed from one double or string
	const LBDouble *dptr = dynamic_cast<const LBDouble*>(arg0);
	if ( dptr != 0 )
	  return new LBInt(int(dptr->_realdouble));

	// the follow is the LBString case
	const LBString *strptr = dynamic_cast<const LBString*>(arg0);
	if ( strptr )
	  {
	    istringstream ist(strptr->str());
	    int x;
	    if ( ist>>x )
	      return new LBInt(x);
	  }
	break;
      }
    default:
      ;
    }
    
    return 0;
  }


  string LBInt::toString() const
  {   
    ostringstream ost;
    ost << _realint;
    return ost.str();
  }

  ostream& LBInt::toStream(ostream& ost) const
  {
    return ost<< _realint;
  }

  istream& LBInt::fromStream(istream& ist, int major, int minor)
  {
    return ist>>_realint;
  }

  bool LBInt::equals(const LBObject& another) const
  {
    const LBInt *intptr = dynamic_cast<const LBInt*>(&another);
    if ( intptr )
      return _realint == intptr->_realint;
    const LBDouble *dblptr = dynamic_cast<const LBDouble*>(&another);
    if ( dblptr)
      return double(_realint) == dblptr->_realdouble;
    return false;
  }

  int LBInt::hash() const
  {   return (int)_realint; }

  bool LBInt::cast(LBObject* target) const
  {
    LBDouble *dptr = dynamic_cast<LBDouble*>(target);
    if ( dptr != 0 )
      {
	dptr->_realdouble = double(_realint);
	return true;
      }
    LBInt *intptr = dynamic_cast<LBInt*>(target);
    if ( intptr != 0 )
      {
	intptr->_realint = _realint;
	return true;
      }

    return false;
  }

  LBInt& LBInt::add(const LBObject& lbo)
  {
    const LBInt* lboptr = dynamic_cast<const LBInt*>(&lbo);
    if ( lboptr )
      {
	_realint += lboptr->_realint;
	return *this;
      }
    throw LBException(string("Can not add LBInt with ")+lbo.getType().toString());
  }

  LBInt& LBInt::sub(const LBObject& lbo)
  {
    const LBInt* lboptr = dynamic_cast<const LBInt*>(&lbo);
    if ( lboptr )
      {
	_realint -= lboptr->_realint;
	return *this;
      }

    throw LBException(string("Can not subtract LBInt with ")+lbo.getType().toString());
  }

  LBInt& LBInt::mul(const LBObject& lbo)
  {
    const LBInt* lboptr = dynamic_cast<const LBInt*>(&lbo);
    if ( lboptr )
      {
	_realint *= lboptr->_realint;
	return *this;
      }
    throw LBException(string("Can not multiply LBInt with ")+lbo.getType().toString());
  }

  LBInt& LBInt::div(const LBObject& lbo)
  {
    const LBInt* lboptr = dynamic_cast<const LBInt*>(&lbo);
    if ( lboptr )
      {
	if ( lboptr->_realint == 0 )
	  throw LBException("Divided by zero");
	_realint /= lboptr->_realint;
	return *this;
      }

    throw LBException(string("Can not divide LBInt with ")+lbo.getType().toString());
  }

  LBInt& LBInt::mod(const LBObject& lbo)
  {
    const LBInt* lboptr = dynamic_cast<const LBInt*>(&lbo);
    if ( lboptr )
      {
	_realint %= lboptr->_realint;
	return *this;
      }

    throw LBException(string("Can not mod LBInt with ")+lbo.getType().toString());
  }

  bool LBInt::before(const LBObject& lbo) const
  {
    const LBInt* lboptr = dynamic_cast<const LBInt*>(&lbo);
    if ( lboptr )
	return _realint < lboptr->_realint;
    const LBDouble* lboptr2 = dynamic_cast<const LBDouble*>(&lbo);
    if ( lboptr2 )
      return _realint < lboptr2->_realdouble;

    throw LBException(string("Can not compare LBInt with ")+lbo.getType().toString());
  }

  LBInt& LBInt::neg()
  {
    _realint = -_realint;
    return *this;
  }

  LBInt& LBInt::plusplus()
  {
    _realint++;
    return *this;
  }
  LBInt& LBInt::minusminus()
  {
    _realint--;
    return *this;
  }
    

}
