#include <iostream>
#include "lbtypes/StreamUtil.hpp"

namespace Luban
{
  using std::ostream;
  using std::istream;

  static const int DoubleSize = 8;

  // determine endianess of the platform
  static bool bigEndian()
  {
    short s = 0x0001;
    const char *bytes = (const char*)(&s);
    return bytes[0] == '\0';
  }

  static const bool Big_Endian_Arch = bigEndian();

  // the convention is to stream in big endian format
  ostream& StreamUtil::serializeDouble(ostream& ost, double x)
  {
    char* bytes = (char*)(&x);
    if ( Big_Endian_Arch )
      for( int i =0; i< DoubleSize; ++i )
	ost.put(*(bytes+i));
    else
      for( int i =DoubleSize-1; i>=0; --i )
	ost.put(*(bytes+i));
    return ost;
  }

  double StreamUtil::de_serializeDouble(istream& ist)
  {
    double target;
    char *bytes = (char*)(&target);

    if ( Big_Endian_Arch )
      for( int i =0; i< DoubleSize; ++i )
	ist.get(*(bytes+i));
    else
      for( int i =DoubleSize-1; i>=0; --i )
	ist.get(*(bytes+i));

    return target;

  }

}
