#ifndef __ATOMICINT_HPP__
#define __ATOMICINT_HPP__

#include "lbthread/lbthread.hpp"

namespace Luban
{
  // this is an FAST/SIMPLE integer class whose operation is ATOMIC, to be
  // used to do reference counting in multi-thread environment.
  // It MUST be fast, so the common POSIX mutex may not be fast enough for it.
  // Its implementation could vary on different platforms.
  // On Linux, FUTEX could be used, which is avaiable from Linux kernel 2.5.7 and up
  class AtomicInt
  {
  public:
    AtomicInt(int initval) : _lock(), _data(initval) {}
    ~AtomicInt() {}
    int inc()
    {
      LBMutexLocker mlock(_lock);
      return ++_data;
    }
    int dec()
    {
      LBMutexLocker mlock(_lock);
      return --_data;
    }

    int compareTo(int i) // return -1 for smaller than i, 0 for equal and 1 for larger than i
    {
      LBMutexLocker mlock(_lock);
      if ( _data > i ) return 1;
      if ( _data == i ) return 0;
      return -1;
    }

    void set(int i)
    {
      LBMutexLocker mlock(_lock);
      _data = i;
    }

  private:
    AtomicInt(const AtomicInt& a);
    AtomicInt& operator=(const AtomicInt& a);

    LBMutex _lock;
    int _data;

  };

}

#endif
