#ifndef __SOCKET_HPP__
#define __SOCKET_HPP__

#include <iosfwd>
#include <string>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"
#include "lbtypes/RefCountedPtr.hpp"

namespace Net
{
  using std::string;
  using std::istream;
  using std::ostream;

  using Luban::LBObject;
  using Luban::LBVarArgs;

  class Socket : public LBObject
  {
    LBDECLARE( Net::Socket )
    
    Socket(const string& hostname, int port); // client socket
    Socket(int socketid, const string& clienthost, int clientport); // server socket

    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    bool equals(const LBObject& another) const;  

    // Socket specific interfaces
    bool operator==(const Socket& x) const
    { return false; }
    bool operator!=(const Socket& x) const
    { return true; }

    // Socket use functions
    bool writeobj(const LBObject& obj) ; // dump binary guts
    LBObject* readobj() ; // restore from binary stream
    void put(const LBObject& obj) ; // write human readable string
    void putLine(const LBObject& obj); // write human readable string, with CR
    bool readLine(string& aline); // read until CR
    bool readChar(char& c) ; // read one char
    void close();
    bool isValid() const;
    const string& errmsg() const;


    LBObject* luban_put(const LBVarArgs *args);
    LBObject* luban_putline(const LBVarArgs *args);

    LBObject* luban_get(const LBVarArgs *args);
    LBObject* luban_getline(const LBVarArgs *args);

    LBObject* luban_writeobj(const LBVarArgs *args);
    LBObject* luban_readobj(const LBVarArgs *args);

    LBObject* luban_close(const LBVarArgs *args);

  private:
    class SocketImp
    {
    public:
      SocketImp(const string& hostname, int port);
      SocketImp(int socketid, const string& clienthost, int clientport); 
      ~SocketImp();
      bool isValid() const;
      void invalidate();
      int readnbytes(char *buf, int n);
      int writenbytes(const char *buf, int n);

      string _host;
      int _port;
      string _errmsg;

      // #ifdef LINUX UNIX
      int _socketid;

    private:
      SocketImp(const SocketImp& s);
      SocketImp& operator=(const SocketImp& s);
    };

    Luban::RefCountedPtr<SocketImp> _socketimp;

  };

}



#endif
