package luban;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.Class;

import java.util.LinkedList;
//import java.util.concurrent.locks.Condition;
//import java.util.concurrent.locks.ReentrantLock;

public class InvocationQueue implements InvocationHandler {

//    private final ReentrantLock lock;
//    private final Condition newItem;

	private LinkedList _invokeq;
	private boolean _closed;
	
	public InvocationQueue()
	{
		_invokeq = new LinkedList();
		_closed = false;
	}
	
	private synchronized void addInvocation(Method m , Object[] args)
	{
		if (  _closed )
		{
			notifyAll();
			return;
		}
		_invokeq.addFirst(new InvocationEvent(m, args));
		notify();
	}
	
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable 
	{
		if ( method.getName().equals("toString"))
			return super.toString();
		if ( method.getName().equals("hashCode"))
			return new Integer(super.hashCode());
		if ( method.getName().equals("equals"))
			return new Boolean( this == args[0] );
		if ( method.getName().equals("wait"))
		{
			int argsz = args == null ? 0: args.length;
			if ( argsz == 0 )
				super.wait();
			if ( argsz >= 1 )
			{
				long timeout = Long.valueOf(args[0].toString()).longValue();
				if ( argsz == 2 )
				{
					int nanos = Integer.valueOf(args[1].toString()).intValue();
					super.wait(timeout, nanos);
				}
				super.wait(timeout);
			}
			super.wait();
			return null;
		}
		if ( method.getName().equals("notify"))
		{
			super.notify();
			return null;
		}
		if ( method.getName().equals("notifyAll"))
		{
			super.notifyAll();
			return null;
		}

		addInvocation(method, args);
		return null;
	}
	
	public synchronized InvocationEvent getInvocation() throws InterruptedException
	{
		if ( _closed ) return null;
		while ( _invokeq.size() == 0 )
		{
			wait();
			if ( _closed ) return null;
		}
		return (InvocationEvent)_invokeq.removeLast();
	}
	
	public synchronized void close()
	{
		_closed = true;
		notifyAll();
	}

	public synchronized void reopen()
	{
		_closed = false;
	}
	
	public Object newProxy(String classname) throws ClassNotFoundException
	{
		Class clazz = Class.forName(classname);
		return Proxy.newProxyInstance(clazz.getClassLoader(),new Class[]{clazz},this);
	}

//	public static void main(String[] args) throws Exception
//	{
//		InvocationQueue proxy = new InvocationQueue();
//		Object fakeobj = proxy.newProxy("java.awt.event.ActionListener");
//		((java.awt.event.ActionListener)fakeobj).actionPerformed(null);
//		Object[] invk = proxy.getInvocation();
//		Object method = invk[0];
//		System.out.println(method);
//		Object[] actargs = (Object[])invk[1];
//		for(int i=0; i<actargs.length; ++i)
//			System.out.println(actargs[i]);
//	}
}
