#include <iostream>
#include <jni.h>

main(int argc, char *argv[]) 
{
  if ( argc != 5 )
    {
      std::cerr << "need 4 args\n";
      return 1;
    }

  JavaVMInitArgs vm_args;
  JavaVMOption options[1];

  /* disable JIT */
  options[0].optionString = "-Djava.compiler=NONE";

  vm_args.version = JNI_VERSION_1_4;
  vm_args.options = options;
  vm_args.nOptions = 1;
  vm_args.ignoreUnrecognized = 1;

  /* Create the Java VM */
  JNIEnv *env;
  JavaVM *jvm;
  jint res = JNI_CreateJavaVM(&jvm,(void**)&env,&vm_args);
  if (res < 0) 
    {
      std::cerr<<"Can't create Java VM\n";
      exit(1);
    }

  jclass clscls = env->FindClass( "java/lang/Class");
  if (clscls == 0) 
    {
      std::cerr<< "Can't find java.lang.Class class\n";
      return 1;
    }
 
  jmethodID mid = env->GetStaticMethodID(clscls, "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
  if (mid == 0) 
    {
      std::cerr << "Can't find java.lang.Class.forName()\n";
      return 1;
    }

  jstring jstr = env->NewStringUTF(argv[1]);
  jobject classobj = env->CallStaticObjectMethod( clscls, mid, jstr);
  if ( ! classobj )
    {
      std::cerr << "Can't find class "<<argv[1]<<"\n";
      return 1;
    }

  jstring jstrclassname = env->NewStringUTF("java.lang.String");
  jstring objclassname = env->NewStringUTF("java.lang.Object");
  jobject strclassobj = env->CallStaticObjectMethod( clscls, mid, jstrclassname);
  jobject objclassobj = env->CallStaticObjectMethod( clscls, mid, objclassname);
  jobjectArray getctrargs = env->NewObjectArray(1, clscls, objclassobj);
  std::cerr << "00000000000000000000000000000"<<"\n";

  jmethodID getctrmethod = env->GetMethodID(clscls, "getConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
  jobject ctrobj = env->CallObjectMethod(classobj, getctrmethod, getctrargs);
  std::cerr << "00000000000000000000000000000"<<"\n";
  if ( ! ctrobj )
    {
      std::cerr << "Can't find constructor for "<<argv[1]<<" that takes a string\n";
      return 1;
    }


  jclass ctrclass = env->FindClass("java/lang/reflect/Constructor");
  jmethodID newinsmethod = env->GetMethodID(ctrclass, "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;");
  jstring jstr2=env->NewStringUTF(argv[2]);
  jobjectArray args = env->NewObjectArray(1, env->FindClass("java/lang/String"), jstr2);
  jobject targetobj = env->CallObjectMethod(ctrobj, newinsmethod, args);
  std::cerr << "00000000000000000000000000000  targetobj "<<targetobj<<"\n";

  // look up method and call
  jmethodID getmthdmthdid = env->GetMethodID(clscls, "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
  std::cerr << "00000000000000000000000000000  getmthdmthdid "<< getmthdmthdid <<"\n";
  jstring targetmthdname = env->NewStringUTF(argv[3]);
  jobjectArray getmthargs = env->NewObjectArray(1, clscls, objclassobj);
  jobject mthdobj = env->CallObjectMethod(classobj, getmthdmthdid, targetmthdname, getmthargs);
  std::cerr << "00000000000000000000000000000  mthobj "<<mthdobj<<"\n";
  jmethodID invkmthdid = env->GetMethodID(env->FindClass("java/lang/reflect/Method"), "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
  std::cerr << "00000000000000000000000000000  invkmthdid "<<invkmthdid<<"\n";
  jstring targetstrarg = env->NewStringUTF(argv[4]);
  jobjectArray targetargs = env->NewObjectArray(1, env->FindClass("java/lang/String"), targetstrarg);
  jstring strobj = static_cast<jstring>(env->CallObjectMethod(mthdobj, invkmthdid, targetobj, targetargs));
  std::cerr << "00000000000000000000000000000  result strobj "<<strobj<<"\n";
  const char *nativestr = env->GetStringUTFChars(strobj, 0);
  std::cout << nativestr <<'\n';
  env->ReleaseStringUTFChars(strobj, nativestr);

  env->DeleteLocalRef(targetobj);

   jvm->DestroyJavaVM();

}
