#ifndef __LBJAVAOBJREF_HPP__
#define __LBJAVAOBJREF_HPP__

#include <iosfwd>
#include <string>

#include "lbjava/jniwrap.hpp"

#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"
#include "lbtypes/RefCountedPtr.hpp"

namespace Java
{
  using std::string;
  using std::istream;
  using std::ostream;
  using std::string;
  using Luban::LBObject;
  using Luban::LBVarArgs;

  class JavaClassInfo;

  class LBJavaObjRef : public LBObject
  {
    LBDECLARE( Java::LBJavaObjRef )

  public:
    LBJavaObjRef();

    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence 
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence
    bool equals(const LBObject& another) const;  

//     bool operator==(const LBJavaObj& x) const;
//     bool operator!=(const LBJavaObj& x) const;

    // optional
    int hash() const ;
    bool cast(LBObject* casttotarget ) const;
    //bool      before(const LBObject& lbo) const;

    // local
    bool isNull() const { return getJavaObj() == 0; }

  private:
    LBJavaObjRef(jobject job, const JavaClassInfo *jclsinfo);
    jobject getJavaObj() const;

  private:
    friend class LBJavaUtil;
    class LBJavaObjRefImp
    {
      jobject _javaobj;
      const JavaClassInfo *_javaclass;
    public:
      LBJavaObjRefImp(jobject javaobj, const JavaClassInfo *javaclass);
      ~LBJavaObjRefImp();

      jobject getJavaObj() const { return _javaobj; }
      const JavaClassInfo *getJavaClass() const { return _javaclass; }

    };

    typedef Luban::RefCountedPtr<LBJavaObjRefImp> LBJavaObjRefImpPtr;
    LBJavaObjRefImpPtr _imp;
 
  };

}



#endif
