#include <iostream>
#include <string>

#include "lbjava/jniwrap.hpp"

#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbvarargs.hpp"
#include "lbtypes/lbsymbol.hpp"

#include "lbjava/LBJavaUtil.hpp"
#include "lbjava/LBJavaObjRef.hpp"


namespace Java
{
  using std::string;
  using std::istream;
  using std::ostream;

  using Luban::LBObject;
  using Luban::LBVarArgs;
  using Luban::LBException;
  using Luban::LBSymbol;

  LBDEFINE_BASIC(Java::LBJavaObjRef, 1, 0 )

  LBJavaObjRef* LBJavaObjRef::staticConstructor(const LBVarArgs* args)
  {
    return LBJavaUtil::buildJavaObj(args);
  }

  LBJavaObjRef::LBJavaObjRef(jobject job, const JavaClassInfo *jclsinfo)
    :_imp( new LBJavaObjRefImp(job, jclsinfo))
  { }

  LBJavaObjRef::LBJavaObjRef()
    :_imp()
  {}

  string LBJavaObjRef::toString() const
  {
    return LBJavaUtil::toString( this );
  }

  ostream& LBJavaObjRef::toStream(ostream& ost) const
  {
    LBJavaUtil::toStream( this, ost );
    return ost;
  }

  istream& LBJavaObjRef::fromStream(istream& ist, int major, int minor)
  {
    LBJavaUtil::fromStream( this, ist );
    return ist;
  }

  bool LBJavaObjRef::equals(const LBObject& x) const
  {
    const LBJavaObjRef *objx = dynamic_cast<const LBJavaObjRef*>(&x);
    if ( objx == 0 )
      return false;
    if ( _imp == objx->_imp )
      return true;
    return LBJavaUtil::equals(this, objx);
  }

  LBObject* LBJavaObjRef::exportedMemberFunc(const LBSymbol& funcname, const LBVarArgs* args )
  {
    return LBJavaUtil::callMemberFunc(this, funcname, args);
  }

  Luban::LBMap* LBJavaObjRef::allMemberFuncs( ) const
  {
    return LBJavaUtil::allMemberFuncs(this);
  }

  int LBJavaObjRef::hash() const
  {
    return LBJavaUtil::hashCode(this);
  }

  bool LBJavaObjRef::cast(LBObject* target) const
  {
    // put java obj to luban doule,int,string,bool,char,vector,map,set here
    // so code like "x=double(javaobj);" could work in Luban
    return LBJavaUtil::cast(this, target);
  }

  jobject LBJavaObjRef::getJavaObj() const
  {
    if ( _imp )
      return _imp->getJavaObj();
    return 0;
  }

  LBJavaObjRef::LBJavaObjRefImp::~LBJavaObjRefImp()
  {
    LBJavaUtil::releaseJavaObjRef(_javaobj);
  }

  LBJavaObjRef::LBJavaObjRefImp::LBJavaObjRefImp(jobject javaobj, const JavaClassInfo *javaclass)
    : _javaobj(javaobj), _javaclass(javaclass)
  {}

}  
