#ifndef __LBRWLOCKEDOBJPTR_HPP__
#define __LBRWLOCKEDOBJPTR_HPP__

#include <memory>
#include <vector>

#include "luban/lbpropertyinfo.hpp"

namespace Luban
{
  class LBObject;
  class LBStruct;
  class LBReadWriteLock;

  class LBWriteLockedObjPtr
  {
  public:
    LBWriteLockedObjPtr();
    LBWriteLockedObjPtr(const LBWriteLockedObjPtr& p);
    LBWriteLockedObjPtr(LBReadWriteLock *rwlock, LBObject *obj);
    ~LBWriteLockedObjPtr();
    void pushObj(LBObject* obj);
    void pushLock(const LBWriteLockedObjPtr& another); // chain lock
    void invalidate(); // tell not to do any thing to touch list because the end operation failed
    void addTouch(LBStruct *st, int propertyIndex, LBPropertyInfo::ExecAttr attr); // add struct to be touched in destructor

    LBObject* operator->();
    const LBObject* operator->() const;

    LBObject& operator*();
    const LBObject& operator*() const;

    operator bool() const;

    LBObject* getRealPtr();

    LBWriteLockedObjPtr& operator=(const LBWriteLockedObjPtr& p);


  private:
    
    struct StructPropertyInfo
    {
      StructPropertyInfo(LBStruct *s, int p, LBPropertyInfo::ExecAttr a)
	: st(s), propertyIndex(p), attr(a)
      {
      }
      LBStruct *st;
      int      propertyIndex;
      LBPropertyInfo::ExecAttr attr;
    };
    class LBWriteLockedObjPtrImp
    {
    public:
      LBWriteLockedObjPtrImp(LBReadWriteLock *rwlock, LBObject *obj);
      ~LBWriteLockedObjPtrImp();
      friend class LBWriteLockedObjPtr;
    private:
      LBWriteLockedObjPtrImp();
      std::vector<LBReadWriteLock*> *_rwlockvec;
      LBObject *_frontObj;
      std::vector<StructPropertyInfo> *_touchList;
      bool _touch;
    };

  private:
    std::auto_ptr<LBWriteLockedObjPtrImp> _imp;
    
  };

  

}

#endif
