#ifndef __LBVARARGS_HPP__
#define __LBVARARGS_HPP__

#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbobject.hpp"
#include "lbtypes/lbtypeinfo.hpp"

namespace Luban
{

  class LBVarArgs
  {
  public:
    virtual ~LBVarArgs() {}
    virtual int numArgs() const = 0;
    virtual const LBObject* getArg(int index) const = 0;
    const LBObject* operator[](int index) const
    { return getArg(index); }
    int assignArgsToLocal( int expectnum, LBObject **localvarsptr) const
    {
      if ( expectnum != numArgs() )
	return 0;
      int i= 0;
      while( i < expectnum && localvarsptr[i] && getArg(i) && localvarsptr[i]->assign(*getArg(i)) ) i++ ;
      return i;
    }

    bool assignArgToLocal( int argidx, LBObject &localvar) const
    {
      if ( argidx >= numArgs() )
	return false;
      if (  getArg(argidx) && localvar.assign(*getArg(argidx)) ) return true;
      return false;
    }

    // this has nothing to do with LBVarArgs which only passes args IN, but it is used together
    // so it is convenient to put it here. So the code won't be repeated everywhere
    // and policy is coded here too.
    static LBObject* setReturnValue(LBObject *retvalue, const LBObject& result)
    {
      if ( retvalue == 0 )
	return result.clone();
      if ( retvalue->assign(result) )
	return retvalue;
      throw LBException(string("Incompatible return argument of type "+retvalue->getType().toString()+" passed in, expecting "+result.getType().toString()));
    }
  };

  class LBSimpleVarArgs : public LBVarArgs
  {
  private:
    const LBObject* *_args;
    int _numargs;
  public:
    LBSimpleVarArgs() : _args(0), _numargs(0) {}
    LBSimpleVarArgs( LBObject **args, int numargs) : _args(const_cast<const LBObject**>(args)), _numargs(numargs) {}
    LBSimpleVarArgs( const LBObject* *args, int numargs) : _args(args), _numargs(numargs) {}
    int numArgs() const { return _numargs; }
    const LBObject *getArg(int index) const { return index < _numargs ? _args[index] : 0; }
  };


  class LBVarArgsShift : public LBVarArgs
  {
  public:
    LBVarArgsShift(int shift, const LBVarArgs *args)
      : _shift(shift), _args(args)
    {
    }
    
    int numArgs() const
    {
      return _args->numArgs()-_shift;
    }

    const LBObject *getArg( int ind) const
    {
      return _args->getArg(ind+_shift);
    }
  private:
    int _shift;
    const LBVarArgs *_args;
  };



}



#endif
