#ifndef __LBOBJPTR_HPP__
#define __LBOBJPTR_HPP__

#include "lbtypes/lbobject.hpp"
#include "lbtypes/RefCountedPtr.hpp"

namespace Luban
{
  class  LBObjPtr : public RefCountedPtr<LBObject>
  {
  public:
    LBObjPtr()
      : RefCountedPtr<LBObject>()
    {}
    
    explicit LBObjPtr(LBObject* objp)
      : RefCountedPtr<LBObject>(objp)
    {}
    string toString() const
    {
      static const string nullstr("null");
      if ( _imp && _imp->_realptr )
	return _imp->_realptr->toString();
      return nullstr;
    }

    void assign(const LBObject& obj)
    {
      uniorzero(*this);
      if ( *this )
	{
	  try {
	  if ( (*this)->assign(obj) )
	    return;
	  }
	  catch (...)
	    {
	    }
	}
      LBObject *oldptr = setRealPtr(obj.clone());
      if ( oldptr ) delete oldptr;
    }
  };
}


#endif
