#ifndef __LBDEFINEMACROS_HPP__
#define __LBDEFINEMACROS_HPP__

#include <typeinfo>
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/LBMemberFuncTable.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbvarargs.hpp"
#include "lbtypes/HashUtil.hpp"
#include "lbtypes/lbmap.hpp"
#include "lbtypes/lbstring.hpp"

// These are the macros to save a lot of typing
// LBDECLARE to be used in header files
// and LBDEFINE used in cpp files to define those declared in LBDECLARE
// A trick to make compiler do typing.
// These macros are only used in SOLID derived class of LBObject
// do not and no need to use it in an abstract class derived from LBObject
//
// What are declared and defined
// 1. virtual clone() function
// 2. virtual bool assign() function which tries to down cast the input then call
//    the assingment operator for the class, return false if unsuccessful
// 3. virtual getType() function returning an instance of its LBTypeInfo
// 4. static ClassName::getInstance() function which returns a default instance


class Luban::LBSymbol;


#define LBDEFAULT_STATIC_CONSTRUCTOR(CPPClassName)                            \
  CPPClassName* CPPClassName::staticConstructor(const LBVarArgs *args)        \
  {                                                                           \
    int numargs = args ? args->numArgs():0;                                   \
    if ( numargs == 0 ) return new CPPClassName;                              \
    if ( numargs == 1 )                                                        \
    {                                                                          \
        const LBObject *obj = args->getArg(0);                                 \
        const CPPClassName *castobj = dynamic_cast<const CPPClassName*>(obj);  \
        if ( castobj ) return new CPPClassName(*castobj);                      \
    }                                                                          \
    return 0;                                                                  \
  }                                                                            \


#define LBDEFAULT_EQUALS_FUNC(CPPClassName)                                           \
  bool CPPClassName::equals(const LBObject& x) const                                  \
  {                                                                                   \
    const CPPClassName *ptr = dynamic_cast<const CPPClassName*>(&x);  \
    if ( ptr  )                                                                       \
      return operator==(*ptr);                                                      \
    return false;                                                                     \
  }                                                                             \




#define LBDEFINE_BASIC( CPPClassName, majorversion, minorversion )               \
  int CPPClassName::factoryRegistered =Luban::LBTypeFactory::registerType( const_cast<Luban::LBTypeInfo*>(&staticTypeInfo())); \
  CPPClassName* CPPClassName::clone() const                   \
  {  return new CPPClassName(*this); }                        \
  bool CPPClassName::assign( const LBObject& lbo)             \
  {                                                           \
       const CPPClassName* ptr = dynamic_cast<CPPClassName*>(const_cast<LBObject*>(&lbo)); \
       if ( ! ptr ) return false;                             \
       *this = *ptr;                                          \
       return true;                                           \
  }                                                           \
  const Luban::LBTypeInfo& CPPClassName::staticTypeInfo()                   \
  {                                                           \
     static Luban::LBTypeInfo *lbt = LBObject::creatLBTypeInfo(typeid(CPPClassName), #CPPClassName, (Luban::LBTypeInfo::LBConstructor)&CPPClassName::staticConstructor, majorversion, minorversion); \
     return *lbt;                                               \
  }                                                               \
  const Luban::LBTypeInfo& CPPClassName::getType() const              \
  {      return staticTypeInfo(); }                                   \



#define LBDEFINE( CPPClassName, majorversion, minorversion )               \
  int CPPClassName::factoryRegistered =Luban::LBTypeFactory::registerType( const_cast<Luban::LBTypeInfo*>(&staticTypeInfo())); \
  CPPClassName* CPPClassName::clone() const                   \
  {  return new CPPClassName(*this); }                        \
  bool CPPClassName::assign( const LBObject& lbo)             \
  {                                                           \
       const CPPClassName* ptr = dynamic_cast<CPPClassName*>(const_cast<LBObject*>(&lbo)); \
       if ( ! ptr ) return false;                             \
       *this = *ptr;                                          \
       return true;                                           \
  }                                                           \
  const Luban::LBTypeInfo& CPPClassName::staticTypeInfo()                   \
  {                                                           \
     static Luban::LBTypeInfo *lbt = LBObject::creatLBTypeInfo(typeid(CPPClassName), #CPPClassName, (Luban::LBTypeInfo::LBConstructor)&CPPClassName::staticConstructor, majorversion, minorversion); \
     return *lbt;                                               \
  }                                                               \
  const Luban::LBTypeInfo& CPPClassName::getType() const              \
  {      return staticTypeInfo(); }                                   \
  static Luban::LBMemberFuncTable<CPPClassName>& __exportedMemberFuncRegistry__()                \
  {                                                                                                           \
     static Luban::LBMemberFuncTable<CPPClassName> __mfreg__;                                                        \
     return __mfreg__;                                                                                        \
  }                                                                                                           \
  Luban::LBObject* CPPClassName::exportedMemberFunc(const LBSymbol& funcname, const LBVarArgs* args ) \
  {                                                                                                           \
    LubanCallable f;                                                                                          \
    if ( ! __exportedMemberFuncRegistry__().find(funcname, f) )                                 \
     throw LBException(string("No such member function ")+funcname.toString() );                              \
    LBObject *optr = (this->*f)(args);                                                                        \
    return optr;                                                                                              \
  }                                                                                                           \
  Luban::LBMap* CPPClassName::allMemberFuncs( ) const		\
  {                                                                                                           \
    const Luban::LBHashMap<LBSymbol, char*>& funcdesc =  __exportedMemberFuncRegistry__().allfuncs(); \
    Luban::LBHashMap<LBSymbol, char*>::Iterator it(funcdesc);     \
    Luban::LBMap *result = new Luban::LBMap();  \
    while ( it.next() )              \
      result->insert(new Luban::LBString( it.currentPair()->key->toString() ), new Luban::LBString( *(it.currentPair()->value))); \
    return result;  \
  }                                                                              \
  static int __exportMemberFunc__(const char* lubanname, CPPClassName::LubanCallable f, const char* synopsis)    \
  {  return __exportedMemberFuncRegistry__().addMemberFunc(lubanname, f, synopsis);   }             \



#define LBEXPORT_MEMBER_FUNC(CPPClassName, memberfuncname, lubanname, synopsis)              \
     static int ___##memberfuncname##_exported__ = __exportMemberFunc__(lubanname,  &CPPClassName::memberfuncname, synopsis);   \








#endif
