#ifndef __LBMACROSDECLARE_HPP__
#define __LBMACROSDECLARE_HPP__

// These are the macros to save a lot of typing
// LBDECLARE to be used in header files
// and LBDEFINE used in cpp files to define those declared in LBDECLARE
// A trick to make compiler do typing.
// These macros are only used in SOLID derived class of LBObject
// do not and no need to use it in an abstract class derived from LBObject
//
// What are declared and defined
// 1. virtual clone() function
// 2. virtual bool assign() function which tries to down cast the input then call
//    the assingment operator for the class, return false if unsuccessful
// 3. virtual getType() function returning an instance of its LBTypeInfo
// 4. static ClassName::getInstance() function which returns a default instance


class LBTypeInfo;
class LBSymbol;
class LBVarArgs;
class LBMap;


#define LBDECLARE( CPPClassName )                        \
public:                                                  \
  static int factoryRegistered;                          \
  static const Luban::LBTypeInfo& staticTypeInfo();             \
  CPPClassName* clone() const;                           \
  bool assign( const LBObject& lbo);                     \
  const Luban::LBTypeInfo& getType() const;                      \
  static CPPClassName* staticConstructor(const Luban::LBVarArgs *args=0) ; \
  Luban::LBObject* exportedMemberFunc(const Luban::LBSymbol& funcname, const Luban::LBVarArgs* lbargs);   \
  Luban::LBMap* allMemberFuncs() const;                                      \
  typedef LBObject* (CPPClassName::*LubanCallable)(const LBVarArgs* args);       \







#endif
