#include <sstream>
#include <string>

#include "lbtypes/lbobject.hpp"
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbvarargs.hpp"

#include "lbstd/deserializer.hpp"


namespace Std
{
  using std::string;
  using std::istringstream;
  using Luban::LBObject;
  using Luban::LBString;
  using Luban::LBVarArgs;
  using Luban::LBSymbol;
  using Luban::LBException;

  LBDEFINE(Std::Deserializer, 1, 0 )

  LBDEFAULT_STATIC_CONSTRUCTOR(Std::Deserializer)
  LBDEFAULT_EQUALS_FUNC(Std::Deserializer)

  string Deserializer::toString() const
  {
    static const string s("std::deserializer");
    return s;
  }

  ostream& Deserializer::toStream(ostream& ost) const
  {
    return ost;
  }

  istream& Deserializer::fromStream(istream& ist, int major, int minor)
  {
    return ist;
  }
    
  LBEXPORT_MEMBER_FUNC(Std::Deserializer, luban_des, "restore", "object restore(string thestream)" ); 
  LBObject* Deserializer::luban_des(const LBVarArgs *args)
  {
    if ( ! args || args->numArgs() != 1 )
      throw LBException("usage: deserializer::restor(string thestreamedobj)");

    const LBString *strm = dynamic_cast<const LBString*>(args->getArg(0));
    if ( !strm )
      throw LBException("usage: deserializer::restor(string thestreamedobj)");

    istringstream ist(strm->str());
    string err;
    LBObject *obj = instanceFromStream(ist, err);
    if ( ! obj )
      throw("Failed to deserialize object from stream: "+err);
    return obj;
  }


}
