package luban;

import java.lang.reflect.Method;

public class InvocationEvent {

	private Method _method;
	private Object[] _args;
	
	public InvocationEvent(Method method, Object[] args)
	{
		_method = method;
		_args = args;
	}
	
	public Method getMethod()
	{
		return _method;
	}
	
	public Object[] getArgs()
	{
		return _args;
	}
	
	public String toString()
	{
		StringBuffer buf = new StringBuffer();
		buf.append("InvocationEvent Method=");
		buf.append(_method);
		buf.append("; Arguments=");
		if ( _args == null )
			buf.append("null");
		else
			for( int i=0; i<_args.length; ++i)
				buf.append(_args[i]);
		return buf.toString();
	}
}
