#ifndef __LBJAVAOBJUTIL_HPP__
#define __LBJAVAOBJUTIL_HPP__

#include <iosfwd>
#include <string>
#include <vector>

#include "lbjava/jniwrap.hpp"

namespace Java
{
  class LBJavaObjRef;
  class Luban::LBVarArgs;
  class Luban::LBObject;
  class Luban::LBMap;
  class Luban::LBSymbol;

  using std::string;
  using std::istream;
  using std::ostream;
  using std::vector;
 
  class LBJavaUtil
  {
  public:
    static LBJavaObjRef* buildJavaObj(const Luban::LBVarArgs* args);
    static string toString(const LBJavaObjRef* lbj);
    static void toStream(const LBJavaObjRef* lbj, ostream& ost);
    static void fromStream(LBJavaObjRef *lbj, istream& ist);
    static bool equals(const LBJavaObjRef *x, const LBJavaObjRef *y);
    static Luban::LBObject* callMemberFunc(LBJavaObjRef *lbj, const Luban::LBSymbol& funcname, const Luban::LBVarArgs* args );
    static Luban::LBMap *allMemberFuncs(const LBJavaObjRef* lbj);
    static int hashCode(const LBJavaObjRef* lbj);
    static bool cast(const LBJavaObjRef* lbj, Luban::LBObject *target);
    static void releaseJavaObjRef(jobject lbj);

    static jobject lubanToJava(JNIEnv *env, const Luban::LBObject* lubanobj);
    static LBJavaObjRef* buildJavaObject(JNIEnv *env, jobject obj);

    static jstring object2jstring(JNIEnv *env, const Luban::LBObject* obj);
    static jclass object2jclass(JNIEnv *env, const Luban::LBObject* obj, string& errmsg);

  private:
    static bool handleCommonJavaUtilCall(JNIEnv *env, jobject javaobj, const Luban::LBSymbol& funcname, const Luban::LBVarArgs *args, jobject& result);

  };

  class JavaClassInfoCache;
  typedef vector<int> MethodIDList;
  typedef Luban::LBHashMap<Luban::LBSymbol, MethodIDList*> MethodMap;
  class JavaClassInfo
  {
    friend class LBJavaUtil;
  private:
    static JavaClassInfoCache *getCache();
    //    static JavaClassInfo *newClassInfo(JNIEnv *env, const string& clsname);
    static JavaClassInfo *newClassInfo(JNIEnv *env, const string& clsname, jobject classobj=0);
    static jobject callConstructor(JNIEnv* env, jobject j_constructor, jobject args);

    string _classname;
    jclass _classobj;
    vector<jobject> _constructors;
    vector<jobject> _methods;
    vector<string> _method_descriptions;
    vector<string> _method_names;
    MethodMap  _methodmap;

    JavaClassInfo(const string& clsname, jclass classobj);

    int numConstructors() const { return _constructors.size();}
    jobject callConstructor(JNIEnv* env, int i, jobject args) const { return callConstructor( env, _constructors[i], args); }
    
    static const JavaClassInfo *getClassInfo(JNIEnv *env, const string& clsname);
    static const JavaClassInfo *getClassInfo(JNIEnv *env, jobject obj);

    jobject newInstance(JNIEnv *env, const Luban::LBVarArgs *args) const;
    jobject callMemberFunc(JNIEnv *env,jobject theobj, const Luban::LBSymbol& fname, const Luban::LBVarArgs* args) const; 
    Luban::LBMap *allMemberFuncs() const;

    jclass getJavaClassObj() const { return (jclass)_classobj; }

  };

}

#endif
