#ifndef __LBJAVAOBJ_HPP__
#define __LBJAVAOBJ_HPP__

#include <iosfwd>
#include <string>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

namespace Java
{
  using std::string;
  using std::istream;
  using std::ostream;
  using std::string;
  using Luban::LBObject;
  using Luban::LBVarArgs;

  class LBJavaObj : public LBObject
  {
    LBDECLARE( Java::LBJavaObj )
    
    LBJavaObj(const LBVarArgs* args);

    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence 
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence
    bool equals(const LBObject& another) const;  

    // File specific interfaces
    bool operator==(const LBJavaObj& x) const;
    bool operator!=(const LBJavaObj& x) const;
    bool instanceof(string javaclass) const;

  private:
    class LBJavaObjImp;
    LBJavaObjImp *_imp;
  
  };

}



#endif
