#include <fstream>
#include <sstream>
#include <string>

#include "lbtypes/lbobject.hpp"
#include "lbtypes/lbchar.hpp"
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbint.hpp"
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbvarargs.hpp"

#include <jni.h>

#include "lbjava/LBJavaObj.hpp"


namespace Java
{
  using std::string;
  using std::ifstream;
  using std::ofstream;
  using std::ostringstream;

  using Luban::LBObject;
  using Luban::LBChar;
  using Luban::LBInt;
  using Luban::LBString;
  using Luban::LBVarArgs;
  using Luban::LBSymbol;
  using Luban::LBException;

  class LBJavaObj::LBJavaObjImp
  {
  public:
    jobject _javaobj;
  };

  LBDEFINE(Java::LBJavaObj, 1, 0 )

  LBJavaObj* LBJavaObj::staticConstructor(const LBVarArgs* args)
  {
    return new LBJavaObj(args);
  }

  LBDEFAULT_EQUALS_FUNC(Java::LBJavaObj)

  LBJavaObj::LBJavaObj(const LBVarArgs* args)
    :_imp(0)
  {
    int numargs = args?args->numArgs():0;
    if ( numargs != 0 )
      {
	
      }
  }

  string File::toString() const
  {
    static const string s("std::file ");
    return s+_filename;
  }

  ostream& File::toStream(ostream& ost) const
  {
    throw LBException("std::file object can not be streamed out");
    return ost;
  }

  istream& File::fromStream(istream& ist, int major, int minor)
  {
    throw LBException("std::file object can not be streamed in");
    return ist;
  }
