#ifndef __LBSTRUCTIOPADASYNCH_HPP__
#define __LBSTRUCTIOPADASYNCH_HPP__

#include <vector>
#include <deque>

#include "lbthread/lbthread.hpp"

#include "luban/lbstructiopad.hpp"

namespace Luban
{
  class LBStructInPadAsynch :  public LBStructInPad
  {
  public:
    LBStructInPadAsynch(int sz=0);
    ~LBStructInPadAsynch();

    //required interface for LBStructInPad
    bool writeValueByExternal(int index, const LBObjPtr& obj) ;
    bool writeValueByExternal(int index, const LBObject& obj) ;
    LBObjPtr readValueByInternal(int index) ;
    LBObject* readUnsharedGuts(int index);
    int size() const { return _inproperties.size(); }
    LBStructInPadAsynch* clone() const { return new LBStructInPadAsynch(_inproperties.size()); }
    int waitForNewInput();
    void waitUntilInputEmpty();
    void dismissWaitingThreads();

  private:
    
    LBStructInPadAsynch& operator=(const LBStructInPadAsynch& ap);
    LBStructInPadAsynch(const LBStructInPadAsynch& ap );

    typedef std::deque<LBObjPtr> ObjQ;
    typedef std::vector<ObjQ> ObjQVec;
    ObjQVec _inproperties;
    int _objtoread;
    int _waitingreaders;
    bool _dismissed;
    LBMutex _mtx;
    LBCondVar _newarrival;
    LBCondVar _emptyq;

  };


  class LBStructOutPadAsynch : public LBStructOutPad
  {
  public:
    LBStructOutPadAsynch(int sz);
    ~LBStructOutPadAsynch();

    // LBStructOutPad required interface
    bool writeValueByInternal(int index, const LBObjPtr& obj) ;
    bool writeValueByInternal(int index, const LBObject& obj) ;
    LBObjPtr readValueByExternal(int index) ;
    int size() const { return _outproperties.size(); }
    LBStructOutPadAsynch *clone() const { return new LBStructOutPadAsynch(_outproperties.size()); }
    void dismissWaitingThreads();

  private:

    LBStructOutPadAsynch(const LBStructOutPadAsynch& ap );
    LBStructOutPadAsynch& operator=(const LBStructOutPadAsynch& ap );

    typedef std::deque<LBObjPtr> ObjQ;
    typedef std::vector<ObjQ> ObjQVec;
    ObjQVec _outproperties;
    int _waitingreaders;
    LBMutex _mtx;
    LBCondVar _newarrival;
    bool _closed;
  };


}

#endif
