#ifndef __LBNS_HPP__
#define __LBNS_HPP__

#include <iosfwd>
#include <string>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"
#include "lbtypes/RefCountedPtr.hpp"

namespace Luban
{
  using std::string;
  using std::istream;
  using std::ostream;

  class LBTypeSpec;

  class LBNS : public LBObject
  {
    LBDECLARE( Luban::LBNS )
    
    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    bool equals(const LBObject& another) const;  

    bool operator==(const LBNS& x) const
    { return true; }
    bool operator!=(const LBNS& x) const
    { return false; }

    // LBNS functions
    LBObject* getobj(const LBFullSymbol &tpname, const LBVarArgs *args) const;
    const LBTypeSpec* gettype(const LBFullSymbol &tpname) const;
    

    // function to export to Luban
    LBObject* luban_getobj(const LBVarArgs *args);
    LBObject* luban_gettype(const LBVarArgs *args);

  };

}

#endif
