#ifndef __LBABSTRACTSTRUCT_HPP__
#define __LBABSTRACTSTRUCT_HPP__

#include <iosfwd>
#include <string>

#include "luban/lbstruct.hpp"
#include "lbtypes/LBDeclareMacros.hpp"


namespace Luban
{
  class LBSymbol;
  class LBFullSymbol;
  class LBNamedArgs;
  class LocalPropertyStorage;
  class CounterWaiter;
  class LBStructInterface;
  using std::string;

  class LBAbstractStruct : public LBStruct
  {
    LBDECLARE(Luban::LBAbstractStruct);
  public:
    ~LBAbstractStruct();
    LBAbstractStruct();
    LBAbstractStruct(const LBAbstractStruct& abs);
    LBAbstractStruct(LBStructInterface* itfc);
    LBAbstractStruct& operator=(const LBAbstractStruct& x);

    // LBObject required interfaces
    string toString() const;
    ostream& toStream( ostream& o ) const ;
    istream& fromStream( istream& i, int major=-1, int minor=-1 );
    bool equals(const LBObject& another) const;

    // common operations for all kind of structs
    const LBStructInterface& interface() const ;
    LBStruct* structCall(const LBNamedArgs* args=0) const ;
    void setBatchProperties(const LBNamedArgs* args=0) ;

    LBObjPtr getPropertyValue(const LBSymbol& s) ;
    LBObject* getPropertyPtr(const LBSymbol& s) ;
    void touchProperty(const LBSymbol& s) ;
    void setProperty(const LBSymbol& s, const LBObject& val) ; //exception if set failed
    void setProperty(const LBSymbol& s, const LBObjPtr& valptr) ; //exception if set failed

    LBObjPtr getPropertyValue(int index, LBPropertyInfo::ExecAttr attr)  ;
    LBObject* getPropertyPtr(int index, LBPropertyInfo::ExecAttr attr) ;
    void touchProperty(int index, LBPropertyInfo::ExecAttr attr) ;
    void setProperty(int index, LBPropertyInfo::ExecAttr attr, const LBObject& val) ; //exception if set failed
    void setProperty(int index, LBPropertyInfo::ExecAttr attr, const LBObjPtr& valptr) ; //exception if set failed

    bool addPending(int staticprpindex) ; // this only applies to static property
    bool removePending(int staticprpindex) ; // this only applies to static property
    bool waitUntilNoPending(int staticprpindex) ; // this only applies to static property
    LBObjPtr getStaticPropertyValue(int index) ;
    void setStaticPropertyValue(int index, const LBObject& val) ;
    void setStaticPropertyValue(int index, const LBObjPtr& valptr);

    LBWriteLockedObjPtr getWriteLockedStaticProperty(int staticprpindex) ; // this only applies to static property
    LBWriteLockedObjPtr getWriteLockedStoreProperty(int staticprpindex) ; // this only applies to store property

  private:
    LBStructInterface *_itfc;
    LocalPropertyStorage *_statics;
    CounterWaiter *_staticscounters;
    
  };
    

}

#endif
