#ifndef __LBTYPESPECTYPETYPE_HPP__
#define __LBTYPESPECTYPETYPE_HPP__

#include <iosfwd>
#include "lbtypes/lbtypespec.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

namespace Luban
{
  using std::string;

  class LBTypeSpecTypeType : public LBTypeSpec
  {
    LBDECLARE(Luban::LBTypeSpecTypeType);
  public:
    LBTypeSpecTypeType()  {}
    ~LBTypeSpecTypeType() {}

    // LBObject required interfaces
    string toString() const;
    ostream& toStream( ostream& o ) const ;
    istream& fromStream( istream& i, int major=-1, int minor=-1 );
    bool equals(const LBObject& another) const;

    // LBTypeSpec required interface
    bool checkObj(const LBObject& obj) const
    {
      const LBTypeSpec *ts = dynamic_cast<const LBTypeSpec*>(&obj);
      return ts != 0;
    }

    // LBTypeSpecTypeType specific member functions
    bool operator==(const LBTypeSpecTypeType& x) const
    {  return true; }
    bool operator!=(const LBTypeSpecTypeType& x) const
    {   return false; }

  private:

  };


}

#endif
