#include <string>

#include "lbtypes/lbtypespecbasic.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/LBDefineMacros.hpp"

namespace Luban
{
  using std::string;

  LBDEFINE(Luban::LBTypeSpecBasic, 1,0)
  LBDEFAULT_STATIC_CONSTRUCTOR(Luban::LBTypeSpecBasic)

  string LBTypeSpecBasic::toString() const
  {  
    if ( ! _realtype )
      return string("any type");
    return _realtype->toString();
  }

  ostream& LBTypeSpecBasic::toStream( ostream& ost ) const
  {
    if ( _realtype )
      {
	ost.put('1'); ost.put(' ');
	_realtype->toStream(ost);
	ost.put(' ');
      }
    else
      {
	ost.put('0');  ost.put(' ');
      }

    return ost;
  }

  istream& LBTypeSpecBasic::fromStream(istream& ist, int major, int minor)
  {
    char indic = ist.get();
    char sp = ist.get();
    if ( ! ist || sp != ' ' || indic != '1' && indic != '0' )
      throw LBException("Corrupted stream, can not recover the begining of a LBTypeSpecBasic");
    string errs;
    if ( indic == '1' )
      {
	_realtype = LBTypeInfo::restoreFromStream(ist, errs);
	ist.get(sp);
	if ( _realtype == 0 || sp != ' ')
	  throw LBException("Error to recover the actual type info for LBTypeSpecBasic: "+string(errs));
      }
    else
      _realtype = 0;

    return ist;

  }

  
  LBDEFAULT_EQUALS_FUNC( Luban::LBTypeSpecBasic )

  //The below to export member functions defined at LBTypeSpec level
  LBEXPORT_MEMBER_FUNC(Luban::LBTypeSpecBasic, luban_create, "instance", "object instance(object arg1, arg2,....)" ); 

}
