#ifndef __LBTYPEINFO_HPP__
#define __LBTYPEINFO_HPP__

#include <iosfwd>
#include <string>
#include <typeinfo>

namespace Luban
{
  using std::string;
  using std::istream;
  using std::ostream;
  using std::type_info;

  class LBVarArgs;
  class LBObject;

  class LBTypeInfo
  {
  public:
    typedef LBObject* (*LBConstructor)(const LBVarArgs*);
    friend class LBObject;

  private:
    LBTypeInfo();
    LBTypeInfo(const type_info& cpptype, const char* cppname, LBConstructor lbc, int major, int minor);

    LBTypeInfo& operator=(const LBTypeInfo& ltp);

    // LBObject required interfaces
//     istream& fromStream( istream& i, int major=-1, int minor=-1 );
//     bool equals(const LBObject& another) const;

  public:
    int hash() const;
    string toString() const;
    ostream& toStream( ostream& o ) const ;
    bool operator==(const LBTypeInfo& another) const;
    bool operator!=(const LBTypeInfo& another) const
    {  return ! operator==(another); }
    bool operator>(const LBTypeInfo& another) const;
    bool operator<(const LBTypeInfo& another) const;
    LBObject* newInstance(const LBVarArgs *args=0) const;
    const char* className() const;
    const char* lubanName() const;
    void setLubanName(const char* name);
    int majorVersion() const;
    int minorVersion() const;

    static const LBTypeInfo* restoreFromStream(istream& i, string &returnerrmsg);


  private:

    class LBTypeInfoImp;
    LBTypeInfoImp* _imp; 

  };

  ostream& operator << (ostream& ost, const LBTypeInfo& lbt);

}

#define LBTYPEID(CPPClassName)  CPPClassName::staticTypeInfo()

#endif
