#ifndef __LBFULLSYMBOL_HPP__
#define __LBFULLSYMBOL_HPP__

#include <vector>
#include <iosfwd>

#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"
#include "lbtypes/RefCountedPtr.hpp"

#include "lbtypes/lbsymbol.hpp"

namespace Luban
{

  class LBFullSymbol : public LBObject
  {
    LBDECLARE(Luban::LBFullSymbol);
  public:
    LBFullSymbol();
    ~LBFullSymbol();

    // LBObject required interfaces
    string toString() const;
    ostream& toStream( ostream& o ) const ;
    istream& fromStream( istream& i, int major=-1, int minor=-1 );
    bool equals(const LBObject& another) const;

    //LBObject optional interfaces
    int hash() const;
    int size() const;

    // LBFullSymbol specific member functions
    void append(const LBSymbol& x); //  oldxxx::x
    void insertFront(const LBSymbol& x); // x::oldxxx
    bool pop(LBSymbol& value); // return false if nothing to pop
    const LBSymbol* nameAtLevel(int level) const;
    bool operator==(const LBFullSymbol& x) const;
    bool operator!=(const LBFullSymbol& x) const
    {   return ! ( operator==(x) ); }

    // it will parse string like "A::B::C"
    static bool stringToFullSymbol(const string& str, LBFullSymbol& result);

  private:
    class LBFullSymbolImp
    {
    public:
      ~LBFullSymbolImp() {}
    private:
      LBFullSymbolImp() : _symbolvec(), _hash(0) {}

      friend class LBFullSymbol;
    private:
      std::vector<LBSymbol> _symbolvec;
      int _hash;
    };

    typedef RefCountedPtr<LBFullSymbolImp> LBFullSymbolImpPtr;

    LBFullSymbolImpPtr _imp;

  };


  typedef std::vector<LBFullSymbol> LBFullSymbolVec;

}


#endif
