#ifndef __LBBOOL_HPP__
#define __LBBOOL_HPP__

#include <string>
#include <iosfwd>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

namespace Luban
{
  using std::string;

  class LBBool : public LBObject
  {
    LBDECLARE( Luban::LBBool )
    
    // constructors
    LBBool(bool x=false): _realbool(x) {}

    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    bool equals(const LBObject& another) const;  

    // optional LBObject interface implemented
    int hash() const { return int(_realbool); }
    // no need to handle string in the below cast operation
    bool cast(LBObject* target ) const; // cast self to the target type, assign to target
    bool      before(const LBObject& lbo) const;
    LBObject& neg() { _realbool = ! _realbool; }

    // LBBool specific interfaces
    bool operator==(const LBBool& x) const
    { return _realbool == x._realbool; }
    bool operator!=(const LBBool& x) const
    { return _realbool != x._realbool; }
    bool operator<(const LBBool& x) const
    { return _realbool < x._realbool; }
    operator bool() const
    {  return _realbool; }
    operator int() const
    {  return (int)_realbool; }
    bool data() const
    {   return _realbool; }

  private:
    bool _realbool;
  };

}


#endif
