#ifndef __LUBANCODEREPOSITORY_HPP__
#define __LUBANCODEREPOSITORY_HPP__

#include <string>

namespace Luban
{
  class LBComponentInfo;
  class LBFullSymbol;
  using std::string;

  class LubanCodeRepository
  {
  public:
    virtual ~LubanCodeRepository() {}
    
    virtual bool persistSymbol(const LBFullSymbol& sym, const LBComponentInfo& symdef, string& errs) = 0;
    virtual LBComponentInfo *retrieveSymbol(const LBFullSymbol& sym, string& errs) = 0;
  };

  class LubanCodeRepositorySimple : public LubanCodeRepository
  {
    bool persistSymbol(const LBFullSymbol& sym, const LBComponentInfo& symdef, string& errs)
    {
      errs += "Code Repository Simple does not support component persistence";
      return false;
    }

    LBComponentInfo *retrieveSymbol(const LBFullSymbol& sym, string& errs)
    {
      errs += "Code Repository Simple does not support component retrieveing";
      return 0;
    }

  };

}

#endif
