#ifndef __LBVECTORSTRUCT_HPP__
#define __LBVECTORSTRUCT_HPP__

#include "luban/lbstruct.hpp"

namespace Luban
{
  class LBVectorizingInfo
  {
  public:
    virtual ~LBVectorizingInfo() {}
    virtual int numVecNames() const = 0;
    virtual const LBSymbol* vecName(int index) const = 0;
    virtual bool parallel() const=0;
  };

  // reminder:  the LBObjPtr could be used to get an efficient vector struct that only does recompute
  //            when necessary, meaning, it can tell if an element of the vector changed or not by doing
  //            simple LBObjPtr comparison

  class LBVectorStruct : public LBStruct
  {
  public:
    LBVectorStruct(const LBStruct& original, const LBVectorizingInfo& vinfo);

    static LBVectorStruct *newVectorStruct(const LBStruct& original, const LBVectorizingInfo& vinfo, string& err)
    { /* to be done */ return 0; }
    static LBVectorStruct *newVectorStruct(LBStruct* original, const LBVectorizingInfo& vinfo, string& err)
    { /* to be done */ return 0; }
    static LBVectorStruct *newVectorStruct(const LBStruct& original, bool multithreading, string& err)
    { /* to be done */ return 0; }
    static LBVectorStruct *newVectorStruct(LBStruct* original, bool multithreading, string& err)
    { /* to be done */ return 0; }
  };

}


#endif
