#include <vector>
#include "luban/lbstructoutpadcomp.hpp"
#include "luban/lbcompositionstruct.hpp"

namespace Luban
{
  LBStructOutPadAsynchComp::LBStructOutPadAsynchComp(int sz)
    : _parentcomp(0), _links(sz, -1)
  {}

  LBStructOutPadAsynchComp::LBStructOutPadAsynchComp(const LBStructOutPadAsynchComp& p)
    : _parentcomp(0), _links(p._links)
  {}

  bool LBStructOutPadAsynchComp::writeValueByInternal(int index, const LBObjPtr& obj)
  {
    if ( _links[index] == -1 )
      return true; // throw away output to unlinked port
    return _parentcomp->_runtime->_livejoints[_links[index]]->setNewValue(obj);
  }

  bool LBStructOutPadAsynchComp::writeValueByInternal(int index, const LBObject& obj)
  {
    if ( _links[index] == -1 )
      return true; // throw away output to unlinked port
    return _parentcomp->_runtime->_livejoints[_links[index]]->setNewValue(obj);
  }

  void LBStructOutPadAsynchComp::linkTo(int idx, int jointid )
  {
    _links[idx]=jointid;
  }


  LBStructOutPadSynchComp::LBStructOutPadSynchComp(int sz)
    : _parentcomp(0), _links(sz, -1), _objs(sz), _updateflags(sz,false)
  {}

  LBStructOutPadSynchComp::LBStructOutPadSynchComp(const LBStructOutPadSynchComp& p)
    : _parentcomp(0), _links(p._links), _objs(p.size()), _updateflags(p.size(),false)
  {}

  bool LBStructOutPadSynchComp::writeValueByInternal(int index, const LBObjPtr& obj)
  {
    _objs[index] = obj;
    _updateflags[index]=true;
    return true;
  }

  bool LBStructOutPadSynchComp::writeValueByInternal(int index, const LBObject& obj)
  {
    _objs[index].assign(obj);
    _updateflags[index]=true;
    return true;
  }

  void LBStructOutPadSynchComp::linkTo(int idx, int jointid )
  {
    _links[idx]=jointid;
  }

  void LBStructOutPadSynchComp::flush()
  {
    for(int i=0; i<_links.size(); i++)
      if ( _links[i] != -1 && _updateflags[i] )
	{
	  _parentcomp->_runtime->_livejoints[_links[i]]->setNewValue(_objs[i]);
	  _updateflags[i] =false;
	}
  }

}
