#ifndef __LBSTRUCT_HPP__
#define __LBSTRUCT_HPP__

#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBObjPtr.hpp"

#include "luban/lbpropertyinfo.hpp"
#include "luban/lbrwlockedobjptr.hpp"

namespace Luban
{
  class LBSymbol;
  class LBFullSymbol;
  class LBNamedArgs;
  class LBStructInterface;
  class LBCompositionStruct;

  class LBStruct : public LBObject
  {
  public:
    // common operations for all kind of structs
    virtual const LBStructInterface& interface() const = 0;
    virtual LBStruct* structCall(const LBNamedArgs* args=0) const = 0;
    virtual void setBatchProperties(const LBNamedArgs* args=0) =0;

    virtual LBObjPtr getPropertyValue(const LBSymbol& s) = 0;
    virtual LBObject* getPropertyPtr(const LBSymbol& s) = 0;
    virtual void touchProperty(const LBSymbol& s) = 0;
    virtual void setProperty(const LBSymbol& s, const LBObject& val) = 0; //exception if set failed
    virtual void setProperty(const LBSymbol& s, const LBObjPtr& valptr) = 0; //exception if set failed

    virtual LBObjPtr getPropertyValue(int index, LBPropertyInfo::ExecAttr attr)  = 0;
    virtual LBObject* getPropertyPtr(int index, LBPropertyInfo::ExecAttr attr) = 0;
    virtual void touchProperty(int index, LBPropertyInfo::ExecAttr attr) = 0;
    virtual void setProperty(int index, LBPropertyInfo::ExecAttr attr, const LBObject& val) = 0; //exception if set failed
    virtual void setProperty(int index, LBPropertyInfo::ExecAttr attr, const LBObjPtr& valptr) = 0; //exception if set failed

    // below are for global variables ( static property of struct )
    virtual bool addPending(int staticprpindex) = 0; // this only applies to static property
    virtual bool removePending(int staticprpindex) = 0; // this only applies to static property
    virtual bool waitUntilNoPending(int staticprpindex) = 0; // this only applies to static property
    virtual LBObjPtr getStaticPropertyValue(int index) = 0;
    virtual void setStaticPropertyValue(int index, const LBObject& val) = 0;
    virtual void setStaticPropertyValue(int index, const LBObjPtr& valptr) = 0;

    virtual LBWriteLockedObjPtr getWriteLockedStaticProperty(int staticprpindex) = 0; // this only applies to static property
    // the below is needed for asynch struct because the internal eval
    // could be running when the store property is accessed
    virtual LBWriteLockedObjPtr getWriteLockedStoreProperty(int index) = 0; // this only applies to store property


    // helper interface for composition
    // The below functions are desigened to use together
    // setInput will only set the input value and set up a dirty flag
    // sync will eval through the struct to make its properties consistent again
    // sync will do almost nothing to an asynch struct
    virtual void setInput(int index, const LBObjPtr& valptr);
    virtual void setInput(int index, const LBObject& val) ;
    virtual void sync();

    // Below threefor link time metadata prepareation
    virtual bool prepareOutputForCompositionUse();
    virtual bool prepareOutputForProcessUse();
    virtual bool linkOutputProperty(const LBSymbol& outprpname, int jointid); 
    
    // run time data prepareation
    virtual bool setRunTimeParentComposition(LBCompositionStruct *parentcomp);

    virtual bool wakeupAsynch(); // wake up the internal thread for asynch struct
    virtual bool initializeProperties(); // initialize input and store properties, run init expression if necessary


    // This section is the member functions for Luban reflection mechanism
    // they are non-virtual for purpose
    LBObject * luban_set( const LBVarArgs *args);
    LBObject * luban_get( const LBVarArgs *args);
    LBObject * luban_start( const LBVarArgs *args);


  };


}

#endif
