#include <string>
#include <typeinfo>
#include <iosfwd>

#include "lbtypes/lbfullsymbol.hpp"
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/lbtypespec.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbvarargs.hpp"

#include "luban/lbns.hpp"
#include "luban/luban_symbolresolver.hpp"


namespace Luban
{
  using std::string;
  using std::istream;
  using std::ostream;

  LBDEFINE(Luban::LBNS, 1, 0 )

  LBDEFAULT_STATIC_CONSTRUCTOR(Luban::LBNS)

  string LBNS::toString() const
  {
    static const string ns("Luban namespace");
    return ns;
  }

  ostream& LBNS::toStream(ostream& ost) const
  {
    return ost;
  }

  istream& LBNS::fromStream(istream& ist, int major, int minor)
  {
    return ist;
  }

  LBDEFAULT_EQUALS_FUNC( Luban::LBNS )

  LBObject *LBNS::getobj(const LBFullSymbol& tpname, const LBVarArgs* args) const
  {
    string errs;
    const LBTypeSpec *tspec = LubanSymbolResolver::resolveTypeSymbol(tpname, errs);
    if ( ! tspec )
      throw LBException("Invalid luban type name, not found in name space. Error: "+errs);

    return tspec->createObj(args);
  }

  const LBTypeSpec *LBNS::gettype(const LBFullSymbol& tpname) const
  {
    string errs;
    const LBTypeSpec *tspec = LubanSymbolResolver::resolveTypeSymbol(tpname, errs);
    if ( ! tspec )
      throw LBException("Invalid luban type name, not found in name space. Error: "+errs);
    return tspec;
  }


  LBEXPORT_MEMBER_FUNC(Luban::LBNS, luban_getobj, "create", "object create(string typename, object arg0,arg1...)" ); 
  LBObject* LBNS::luban_getobj(const LBVarArgs *args)
  {
    int numargs = args?args->numArgs():0;
    if ( numargs <= 0 )
      throw LBException("luban::ns::create() function requires one more arguments");
    
    const LBString *tpnamestr = dynamic_cast<const LBString*>(args->getArg(0));
    
    if ( ! tpnamestr )
      throw LBException("luban::ns::create() function requires first arguement be string type");
    
    LBFullSymbol typesym;
    string errs;
    if ( ! LBFullSymbol::stringToFullSymbol(tpnamestr->str(), typesym) )
      throw LBException("invalid type symbol format: "+tpnamestr->str());
  
    LBVarArgsShift svargs(1, args);
    return getobj(typesym, &svargs);

  }

  LBEXPORT_MEMBER_FUNC(Luban::LBNS, luban_gettype, "gettype", "typeinfo gettype(string typename)" ); 
  LBObject* LBNS::luban_gettype(const LBVarArgs *args)
  {
    int numargs = args?args->numArgs():0;
    if ( numargs != 1 )
      throw LBException("luban::ns::create() function requires one argument as type name");
    
    const LBString *tpnamestr = dynamic_cast<const LBString*>(args->getArg(0));
    
    if ( ! tpnamestr )
      throw LBException("luban::ns::gettype() function requires first arguement be string type");
    
    LBFullSymbol typesym;
    string errs;
    if ( ! LBFullSymbol::stringToFullSymbol(tpnamestr->str(), typesym) )
      throw LBException("invalid type symbol format: "+tpnamestr->str());
  
    return gettype(typesym)->clone();

  }
}
