#include <iostream>
#include <string>

#include "lbtypes/lbtypespecrange.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/LBObjPtr.hpp"
#include "lbtypes/lbobject.hpp"

namespace Luban
{
  using std::string;

  LBDEFINE(Luban::LBTypeSpecRange, 1,0)
  LBDEFAULT_STATIC_CONSTRUCTOR(Luban::LBTypeSpecRange)

  LBTypeSpecRange::LBTypeSpecRange( const LBObject& s, const LBObject& e)
    : _startp(), _endp()
  {
    if ( s.getType() != e.getType() )
      throw LBException("Both ends of a range type spec must be of the same type");
    _startp = LBObjPtr(s.clone());
    _endp = LBObjPtr(e.clone());
  }

  LBTypeSpecRange::LBTypeSpecRange( LBObject* s, LBObject* e)
    : _startp(), _endp()
  {
    if ( s == 0 || e == 0 || s->getType() != e->getType() )
      throw LBException("Both ends of a range type spec must be of the same type");
    _startp = LBObjPtr(s);
    _endp = LBObjPtr(e);
  }

  string LBTypeSpecRange::toString() const
  {  
    string s = "range <";
    s += _startp->toString();
    s += ',';
    s += _endp->toString();
    s += '>';
    return s;
  }

  ostream& LBTypeSpecRange::toStream( ostream& ost ) const
  {
    instanceToStream(ost, *_startp);
    instanceToStream(ost, *_endp);
    return ost;
  }

  istream& LBTypeSpecRange::fromStream(istream& ist, int major, int minor)
  {
    string errs;
    LBObject *s = instanceFromStream(ist, errs);
    if ( !ist || s == 0 )
      throw LBException("Corrupted stream, can not recover the start of a range type spec: "+string(errs));
    LBObject *e = instanceFromStream(ist, errs);
    if ( !ist || e == 0 )
      throw LBException("Corrupted stream, can not recover the end of a range type spec: "+string(errs));

    _startp = LBObjPtr(s);
    _endp = LBObjPtr(e);
    return ist;

  }

  bool LBTypeSpecRange::checkObj(const LBObject& obj) const
  {
    if ( obj.getType() != _startp->getType() )
      return false;
    try {
      return ( obj.equals(*_startp) || _startp->before(obj) ) && ( obj.equals(*_endp) || obj.before(*_endp) );
    }
    catch (...) {}
    return false;
  }
  
  LBDEFAULT_EQUALS_FUNC( Luban::LBTypeSpecRange )


}
