#include <iostream>
#include <string>

#include "lbtypes/lbtypespecenum.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbset.hpp"
#include "lbtypes/lbiterator.hpp"
#include "lbtypes/lbvarargs.hpp"
#include "lbtypes/LBDefineMacros.hpp"

namespace Luban
{
  using std::string;

  LBDEFINE(Luban::LBTypeSpecEnum, 1,0)
  LBDEFAULT_STATIC_CONSTRUCTOR(Luban::LBTypeSpecEnum)

  string LBTypeSpecEnum::toString() const
  {
    string s("enum <");
    LBConstIterator *it = _enum.getIterator();
    bool first = true;
    while( it->next() )
      {
	const LBObject *obj = (*it->getCurrentRow())[0];
	if ( !first )
	  s += ',';
	s += obj->toString();
	first = false;
      }
    s += '>';
    delete it;
    return s;
  }

  ostream& LBTypeSpecEnum::toStream( ostream& ost ) const
  {
    int sz = size();
    ost << sz;
    ost.put(' ');
    LBConstIterator *it = _enum.getIterator();
    while( it->next() )
      {
	const LBObject *obj = (*it->getCurrentRow())[0];
	LBObject::instanceToStream(ost,*obj);
      }
    delete it;
    return ost;
  }

  istream& LBTypeSpecEnum::fromStream( istream& ist, int major, int minor )
  {
    int sz = -1;
    ist >>sz;
    char sp = ist.get();
    if ( !ist || sp !=' ' || sz < 0)
      throw LBException("Corrupted stream, can not recover the size of LBTypeSpecEnum");
    string errs;
    _enum.clear();
    for( int i=0; i<sz; i++)
      {
	LBObject *obj = LBObject::instanceFromStream(ist, errs);
	if ( obj == 0 )
	  throw LBException("Error to recover the element for LBTypeSpecEnum: "+string(errs));
	_enum.insert(obj);
      }
    return ist;
  }

  LBDEFAULT_EQUALS_FUNC( Luban::LBTypeSpecEnum )

}
