#ifndef __LBTYPEFACTORY_HPP__
#define __LBTYPEFACTORY_HPP__

namespace Luban
{
  class LBTypeInfo;
  class LBFullSymbol;

  class LBTypeFactory
  {
  public:
    // All the non-const pointers passed in for below two functions 
    // will be owned by the factory
    // though the factory won't free them until the process ends
    // because the factory is a global singleton
    static int registerType(LBTypeInfo* t);
    static int registerDLL(char* cppclassname, char* dllname, char* lubantypename=0);

    static const LBTypeInfo* findType(const char* cppclassname);
    static const char* findDLL(const char* cppclassname);
    static const char* errorMessage(const char* classname);


    // This is for the call from Luban code side
    static const LBTypeInfo* findLubanType(const LBFullSymbol& lubanfulltypename );
    static const char* checkLubanTypeError(const LBFullSymbol& lubanfulltypename );
    static const char* findCPPClassName(const  LBFullSymbol& lubanfulltypename );

  };

}


#endif
