#include <string>
#include <typeinfo>
#include "lbtypes/lbnull.hpp"
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbvarargs.hpp"


namespace Luban
{
  using std::string;

  LBDEFINE(Luban::LBNull, 1, 0 )

  LBDEFAULT_EQUALS_FUNC( Luban::LBNull )

  string LBNull::toString() const
  {
    static const string s("NULL");
    return s;
  }

  ostream& LBNull::toStream(ostream& ost) const
  {
    return ost;
  }

  istream& LBNull::fromStream(istream& ist, int major, int minor)
  {
    return ist;
  }

  bool LBNull::before(const LBObject& lbo) const
  {
    const LBNull* lboptr = dynamic_cast<const LBNull*>(&lbo);
    if ( lboptr )
	return false;

    throw LBException(string("Can not compare LBNull with ")+lbo.getType().toString());
  }


}
