#ifndef __DESERIALIZER_HPP__
#define __DESERIALIZER_HPP__

#include <iosfwd>
#include <string>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

namespace Std
{
  using std::string;
  using std::istream;
  using std::ostream;

  using Luban::LBObject;
  using Luban::LBVarArgs;

  class Deserializer : public LBObject
  {
    LBDECLARE( Std::Deserializer )
    
    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    bool equals(const LBObject& another) const;  

    // Deserializer specific interfaces
    bool operator==(const Deserializer& x) const
    { return true; }
    bool operator!=(const Deserializer& x) const
    { return false; }

    // Deserializer use functions
    LBObject* luban_des(const LBVarArgs *args);

  };

}



#endif
