#ifndef __LBSTRUCTOUTPADCOMP_HPP__
#define __LBSTRUCTOUTPADCOMP_HPP__

#include <vector>

#include "luban/lbstructiopad.hpp"
#include "lbtypes/LBObjPtr.hpp"
#include "lbtypes/lbexception.hpp"

namespace Luban
{
  class LBCompositionStruct;
  class LBStructOutPadAsynchComp : public LBStructOutPad
  {
  public:
    LBStructOutPadAsynchComp(int sz);

    // LBStructOutPad required interface
    bool writeValueByInternal(int index, const LBObjPtr& obj) ;
    bool writeValueByInternal(int index, const LBObject& obj) ;
    LBObjPtr readValueByExternal(int index) 
    { throw LBException("This output pad is only to be used in a composition, readValueByExternal not supported"); }
    
    int size() const { return _links.size(); }
    LBStructOutPadAsynchComp *clone() const { return new LBStructOutPadAsynchComp(*this); }

    void linkTo(int idx, int jointid );
    void setParentComposition(LBCompositionStruct *parentcomp)
    { _parentcomp = parentcomp; }

  private:
    LBStructOutPadAsynchComp& operator=(const LBStructOutPadAsynchComp& ap );
    LBStructOutPadAsynchComp(const LBStructOutPadAsynchComp& ap );

    LBCompositionStruct *_parentcomp;
    std::vector<int> _links;
  };


  class LBStructOutPadSynchComp : public LBStructOutPad
  {
  public:
    LBStructOutPadSynchComp(int sz);

    // LBStructOutPad required interface
    bool writeValueByInternal(int index, const LBObjPtr& obj) ;
    bool writeValueByInternal(int index, const LBObject& obj) ;
    LBObjPtr readValueByExternal(int index)
    { throw LBException("This output pad is only to be used in a composition, readValueByExternal not supported"); }
    int size() const { return _links.size(); }
    LBStructOutPadSynchComp *clone() const { return new LBStructOutPadSynchComp(*this); }

    void flush();
    void linkTo(int idx, int jointid );
    void setParentComposition(LBCompositionStruct *parentcomp)
    { _parentcomp = parentcomp; }

  private:
    LBStructOutPadSynchComp& operator=(const LBStructOutPadSynchComp& ap );
    LBStructOutPadSynchComp(const LBStructOutPadSynchComp& ap );

    LBCompositionStruct *_parentcomp;
    std::vector<int> _links;
    std::vector<LBObjPtr> _objs;
    std::vector<bool> _updateflags;
  };


}

#endif
