#ifndef __LBPROPERTYINFO_HPP__
#define __LBPROPERTYINFO_HPP__

#include <string>

#include "lbtypes/lbtypespec.hpp"
#include "lbtypes/lbsymbol.hpp"
#include "lbtypes/lbfullsymbol.hpp"

#include "luban/luban_parsetree.hpp"

namespace Luban
{
  using std::string;
  class LBProcessStruct;

  class LBPropertyInfo
  {
  public:
    enum ExecAttr{ IN, OUT, STORE, STATIC, INVALIDATTR };
    enum RWPermission { READONLY, HIDDEN, READWRITE, INVALIDRWP  };

    LBPropertyInfo(const LBSymbol& n,  ExecAttr a, RWPermission r, LBProcessStruct *initprc=0 );
    LBPropertyInfo(const LBSymbol& n,  ExecAttr a, RWPermission r, Tree typetree, LBFullSymbolVec *exts, const LBFullSymbol& homens, LBProcessStruct *initprc=0 );
    LBPropertyInfo(const LBSymbol& n,  ExecAttr a, RWPermission r, LBTypeSpec *tspec, LBProcessStruct *initprc=0 );
    LBPropertyInfo(const LBPropertyInfo& p);

    ~LBPropertyInfo();

    const LBSymbol& name() const
    {   return _name; }
    ExecAttr attr() const
    { return _attr; }
    RWPermission permission() const
    { return _permission; }
    const LBTypeSpec* typeSpec() const
    { return _type; }
    const LBProcessStruct *initProcess() const
    { return _initprc; }

    string toString() const;

    // for compile/link query
    const LBFullSymbolVec *externalSymbols() const
    { return _extsymbols; }
    bool resolveType(string& errs);

    static RWPermission defaultRWPermission(ExecAttr a);
    static bool consistent( ExecAttr a, RWPermission r);
    static const string& attrToString(ExecAttr a);
    static const string& rwpermissionToString(RWPermission p);
 
  private:
    LBPropertyInfo& operator = (const LBPropertyInfo& p);

    LBSymbol _name;
    ExecAttr _attr;
    RWPermission _permission;
    LBTypeSpec *_type;
    TreeNode *_typetree;
    LBFullSymbolVec *_extsymbols;
    LBFullSymbol _homens;
    LBProcessStruct *_initprc;

  };


}
#endif
