#include <string>
#include <sstream>
#include <iostream>

#include "lbtypes/lberror.hpp"
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbvarargs.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/HashUtil.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/RefCountedPtr.hpp"
#include "lbtypes/lbtypeinfo.hpp"


namespace Luban
{
  using std::string;
  using std::istringstream;
  
  LBDEFINE(Luban::LBError, 1, 0 )

    //static
  LBError* LBError::staticConstructor(const LBVarArgs* args)
  {
    if ( args == 0 || args->numArgs() == 0 )
      return new LBError();
    
    switch ( args->numArgs() ) {
    case 1:
      {
	const LBString* str = dynamic_cast<const LBString*>(args->getArg(0));
	// error can be constructed from everything
	if ( str != 0 )
	  return new LBError(str->c_str());
	return 0;
	break;
      }
    default:
      ;
    }
    
    return 0;
  }

  LBError::LBError() 
    : _imp( defaultGuts() )
  {
  }

  LBError::LBError(const string& str) 
    : _imp(new LBErrorImp(str) )
  {
  }

  LBError::LBError(const char* cstr) 
    : _imp(new LBErrorImp(cstr) )
  {
  }

  string LBError::toString() const
  {
    static const string prefix("ERROR: ");
    return prefix + _imp->_errormsg;
  }
  
  ostream& LBError::toStream(ostream& o) const
  {     return o << _imp->_errormsg.size()<<' '<<_imp->_errormsg ;  }

  istream& LBError::fromStream(istream& i, int major, int minor)
  {
    string s;
    int length=0;
    i>>length;
    if ( i && i.get() ==' ' ) // skip a space
      for( int j = 0; i && j < length; j++ ) s += i.get();
    else
      throw LBException("Corrupted stream, error recovering LBError from stream");
    if (i )
      {
	unicopy(_imp);
	_imp->_errormsg =s;
      }
    else
      throw LBException("Corrupted stream, error recovering LBError from stream");
    return i;
  }

  LBDEFAULT_EQUALS_FUNC(Luban::LBError)

  bool LBError::operator==(const LBError& x) const
  {      return _imp == x._imp || _imp->_errormsg == x._imp->_errormsg ; }

  int LBError::hash() const
  {    return HashFunctions::stringHash(_imp->_errormsg); }

  LBError& LBError::add(const LBObject& lbo)
  {
    const LBError *p = dynamic_cast<const LBError*>(&lbo);
    if ( p )
      {
	unicopy(_imp);
	_imp->_errormsg += p->_imp->_errormsg;
	return *this;
      }

    throw LBException(string("Can not add LBError with ")+lbo.getType().toString());
  }

  bool LBError::before(const LBObject& lbo) const
  {
    const LBError *p = dynamic_cast<const LBError*>(&lbo);
    if ( p )
      return _imp->_errormsg < p->_imp->_errormsg;

    throw LBException(string("Can not compare LBError with ")+lbo.getType().toString());
  }

  void LBError::clear()
  {  _imp = defaultGuts(); }

  // following are the member functions exported to Luban
  // function exported to Luban need to have the same signature
  // and basically act as adapter to pass the call to the "real" member functions

  LBEXPORT_MEMBER_FUNC(Luban::LBError, luban_clear, "clear", "void clear()"); 
  LBObject* LBError::luban_clear(const LBVarArgs *args)
  {
    if ( args == 0 || args->numArgs() == 0 )
      {
	clear();
	return 0;
      }
    throw LBException(string("clear function expect no arguments"));	    
  }


}

