#ifndef __LBCONTAINER_HPP__
#define __LBCONTAINER_HPP__

#include "lbtypes/lbobject.hpp"

// abstrct class to define the extra interfaces on top of LBObject class

namespace Luban
{
  class LBContainer : public LBObject
  {
  public:
    virtual ~LBContainer() {}
    
    // for the [] operator in Luban
    virtual bool subscriptSet(const LBObject& index, const LBObject& value) = 0;
    virtual const LBObject* subscriptGet(const LBObject& index) const = 0;
    virtual LBObject* subscriptGet(const LBObject& index) = 0;
    virtual int size() const = 0;
    virtual int objPerRow() const = 0;

    // for dynamic type checking, probably this apply to LBObject level
    virtual int typeDimension() const = 0;  // example, vector is 1 dimension, map is 2 dimension, set is 1 dimension 
    virtual const LBTypeExpSet&  actualTypes(int dimensionIndex) const = 0; // get set of types contained in the specified dimension
    virtual bool setTypeChecking(const LBTypeExp& enforcedtype); // ?? we may not want the type stick with the obj, it should stick with the variable
    virtual const LBTypeExp& getTypeChecking();

    // iteration
    virtual LBIterator begin();


  };


}

#endif
