
// THIS IS FOR LINUX/UNIX
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>
// THIS IS FOR LINUX/UNIX

#include <string>
#include <sstream>
#include <cstdio>
#include <cstdlib>
#include <cstring>

#include "lbtypes/lbobject.hpp"
#include "lbtypes/lbint.hpp"
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbvarargs.hpp"
#include "lbtypes/RefCountedPtr.hpp"

#include "lbnet/portlistener.hpp"
#include "lbnet/socket.hpp"


namespace Net
{
  using std::string;
  using std::ostringstream;
  using Luban::LBObject;
  using Luban::LBInt;
  using Luban::LBString;
  using Luban::LBVarArgs;
  using Luban::LBSymbol;
  using Luban::LBException;

  static const int OBJHEADERSIZE = 32;

  LBDEFINE(Net::Portlistener, 1, 0 )

  Portlistener* Portlistener::staticConstructor(const LBVarArgs* args)
  {
    if ( args == 0 || args->numArgs() != 1 )
      throw LBException("to open a listener net::listener(int port)");

    const LBInt *port = dynamic_cast<const LBInt*>(args->getArg(0));
    if ( ! port )
      throw LBException("to open a portlistener net::listener(int port)");
    
    Portlistener *pl = new Portlistener( int(*port));
    if ( pl->isValid() )
      return pl;
    delete pl;
    throw LBException("Failed to open net::listener at port "+port->toString());
  }

  LBDEFAULT_EQUALS_FUNC(Net::Portlistener)

  Portlistener::Portlistener(int port )
    : _portlistenerimp(new PortlistenerImp(port))
  {
    ostringstream ost;
    ost<<port;
    string portstr = ost.str();

    // #ifdef LINUX UNIX SOLARIS
    // create blank portlistener
    int sckid = ::socket(AF_INET, SOCK_STREAM, 0);
    if( sckid < 0 ) 
      {
	_portlistenerimp->_errmsg = "Failed to open socket";
	return;
      }

    struct sockaddr_in sv_addr;
    bzero((char *) &sv_addr, sizeof(sv_addr));
    sv_addr.sin_family = AF_INET;
    sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    sv_addr.sin_port = htons(port);

    // bind portlistener
    if ( bind(sckid, (struct sockaddr *) &sv_addr, sizeof(sv_addr)) < 0 )
      {
	_portlistenerimp->_errmsg = "cannot bind to specified port number "+portstr;
	return;
      }

    // connect to remote server
    if ( listen(sckid, 5 ) < 0 ) 
      {
	_portlistenerimp->_errmsg = "cannot listen to port "+portstr;
	return;
      }
   
    _portlistenerimp->_socketid = sckid;

  }

  string Portlistener::toString() const
  {
    static const string s("net::listener ");
    static const string sbad("net::listener invalid");
    if ( ! _portlistenerimp->isValid() )
      return sbad;
    ostringstream ost;
    ost<<_portlistenerimp->_port;
    return s+ost.str();
  }

  ostream& Portlistener::toStream(ostream& ost) const
  {
    throw LBException("net::listener object can not be streamed out");
    return ost;
  }

  istream& Portlistener::fromStream(istream& ist, int major, int minor)
  {
    throw LBException("net::listener object can not be streamed in");
    return ist;
  }

  Socket* Portlistener::accept()
  {
    if ( _portlistenerimp->isValid() )
      {
	struct sockaddr_in cli_addr;
	int clilen = sizeof(cli_addr);
	bzero((char *) &cli_addr, clilen);
	int sckid = ::accept(_portlistenerimp->_socketid, (struct sockaddr*)&cli_addr, (socklen_t*)&clilen);
	if ( sckid < 0 )
	  throw LBException("Failed to accept incoming connection");
	char *cliaddrstr = ::inet_ntoa(cli_addr.sin_addr);
	string cliaddrstring(cliaddrstr);
	int port = ::ntohs(cli_addr.sin_port);
	return new Socket(sckid, cliaddrstring, port);
      }

    throw LBException("Invalid listener can not accept incoming socket connection: "+_portlistenerimp->_errmsg);
    return false;
  }

  void Portlistener::close()   
  {
    if ( _portlistenerimp->isValid() )
      {
	::close(_portlistenerimp->_socketid);
	_portlistenerimp->_socketid = -1;
      }
  }

  bool Portlistener::isValid() const
  {
    return _portlistenerimp->isValid();
  }

    
  LBEXPORT_MEMBER_FUNC(Net::Portlistener, luban_accept, "accept", "socket accept()" ); 
  LBObject* Portlistener::luban_accept(const LBVarArgs *args)
  {
    if ( args && args->numArgs() != 0 )
      throw LBException("listener::accept() takes no argument");
    return accept();
  }
    
  LBEXPORT_MEMBER_FUNC(Net::Portlistener, luban_close, "close", "void close()" ); 
  LBObject* Portlistener::luban_close(const LBVarArgs *args)
  {
    if ( args && args->numArgs() != 0 )
      throw LBException("listener::close() takes no argument");
    close();
    return 0;
  }


  // helper class
  Portlistener::PortlistenerImp::PortlistenerImp( int port)
    : _port(port), _errmsg(), _socketid(-1)
  {}

  Portlistener::PortlistenerImp::~PortlistenerImp()
  {
    if ( _socketid != -1 )
      ::close(_socketid);
  }

  bool Portlistener::PortlistenerImp::isValid() const
  {
    return _socketid != -1;
  }

}
