#ifndef __LUBANTYPECHECKING_HPP__
#define __LUBANTYPECHECKING_HPP__

#include "lbtypes/lbobject.hpp"
#include "lbtypes/lbtypespec.hpp"
#include "lbtypes/lberror.hpp"

namespace Luban
{
  // place to keep type checking policy
  class LubanTypeChecking
  {
  public:
    static bool checkType(const LBTypeSpec* typespec, const LBObject* obj)
    {
      if ( ! typespec ||  ! obj )
	return true;

      const LBError *e = dynamic_cast<const LBError*>(obj);
      if ( e ) 
	return true;

      return typespec->checkObj(*obj);
    }
  };
      
}

#endif
