#ifndef __LUBAN_NAMESPACE_HPP__
#define __LUBAN_NAMESPACE_HPP__

#include <string>
#include <iosfwd>

#include "lbthread/lbthread.hpp"

#include "lbtypes/HashUtil.hpp"
#include "lbtypes/lbsymbol.hpp"
#include "lbtypes/lbfullsymbol.hpp"

namespace Luban
{
  class LBComponentInfo;

  using std::string;

  class LBNameSpace
  {
    friend class LubanSymbolResolver;
  private:
    bool addSymbol( const LBSymbol& name, LBNameSpace *content);
    bool addSymbol( const LBSymbol& name, LBComponentInfo *typemeta);
    bool addOrReplaceSymbol( const LBSymbol& name, LBComponentInfo *typemeta);

    bool removeSymbol( const LBSymbol& name);

    bool findSymbol(const LBSymbol& name, LBNameSpace* &ns, LBComponentInfo* &st);
    LBNameSpace* findNS(const LBSymbol& name);
    LBComponentInfo* findComponent(const LBSymbol& name);

    LBNameSpace *parent() const { return _parent; } // parent ns containing this
    bool isRoot() const { return parent() == 0; };

    const LBSymbol& name() const { return _name; }
    const LBFullSymbol& fullName() const { return _fullname; }

    friend class LBNSUtil;
  private:
    LBNameSpace();
    LBNameSpace(const LBSymbol& nm, LBNameSpace *parent);
    LBNameSpace(const LBNameSpace& ns);
    const LBNameSpace& operator=(const LBNameSpace& ns);
    ~LBNameSpace();

  private:
    class NSItem
    {
    public:
      friend class LBNameSpace;
      friend class LBNSUtil;
    private:
      NSItem() : _component(0), _ns(0) {}
      NSItem(LBComponentInfo *comp): _component(comp), _ns(0) {}
      NSItem(LBNameSpace* ns): _component(0), _ns(ns) {}
      ~NSItem();
      bool isNS() const { return _ns != 0 ; }
      LBComponentInfo* getComponent() const { return _component; }
      LBNameSpace* getNS() { return _ns; }

      LBComponentInfo *_component;
      LBNameSpace *_ns;
    };
       

  private: // data members
    LBSymbol _name;
    LBFullSymbol _fullname;
    LBNameSpace *_parent;
    typedef LBHashMap<LBSymbol, NSItem*> NSMap;
    NSMap _content;
    LBReadWriteLock _rwlock;
  };

  class LBNSUtil
  {
  public:
    static LBNameSpace* findOrCreateNS(const LBSymbol& name, LBNameSpace* parentns, string& errs);
    static LBNameSpace* findOrCreateNS(const LBFullSymbol& fullname, string& errs);

    enum STATUS { SUCCEED, TERMINAL, NONEXIST };
    static LBNameSpace* findNS(const LBFullSymbol& fullname, STATUS &st);

    static LBNameSpace* rootNS();

    static ostream& printNS(LBNameSpace *ns, ostream& ost, bool recursive=false, int indent=0);
    
  };

}

#endif
