#ifndef __LBSTRUCTIOPADLOCAL_HPP__
#define __LBSTRUCTIOPADLOCAL_HPP__

#include "lbtypes/LBObjPtr.hpp"
#include "luban/lbstructiopad.hpp"
#include <vector>

namespace Luban
{
  class LBStructInPadLocal : public LBStructInPad
  {
  public:
    LBStructInPadLocal(int sz)
      : _inproperties(sz)
    {}

    //required interface for LBStructInPad
    bool writeValueByExternal(int index, const LBObjPtr& obj) ;
    bool writeValueByExternal(int index, const LBObject& obj) ;
    LBObjPtr readValueByInternal(int index) ;
    LBObject* readUnsharedGuts(int index);
    int size() const ;
    LBStructInPadLocal *clone() const;
  private:
    std::vector<LBObjPtr> _inproperties;

  };

  class LBStructOutPadLocal : public LBStructOutPad
  {
  public:
    LBStructOutPadLocal(int sz)
      : _outproperties(sz)
    {}

    // LBStructOutPad required interface
    bool writeValueByInternal(int index, const LBObjPtr& obj) ;
    bool writeValueByInternal(int index, const LBObject& obj) ;
    LBObjPtr readValueByExternal(int index) ;
    int size() const ;
    LBStructOutPadLocal *clone() const;

  private:
    std::vector<LBObjPtr> _outproperties;

  };

}

#endif
