#ifndef __LBSTRUCTINTERFACE_HPP__
#define __LBSTRUCTINTERFACE_HPP__

#include <iosfwd>
#include <vector>
#include <string>

#include "lbtypes/lbfullsymbol.hpp"
#include "lbtypes/HashUtil.hpp"
#include "lbtypes/lbexception.hpp"

#include "luban/lbstructinterface.hpp"
#include "luban/lbpropertyinfo.hpp"

namespace Luban
{
  class LBSymbol;
  class LBTypeSpec;
  class LBProcessStruct;
  using std::string;

  class LBStructInterface
  {
  public:
    enum ExecMode { SYNCH, ASYNCH, STATIONARY };

    LBStructInterface(ExecMode m=SYNCH);
    LBStructInterface(const LBStructInterface& i);
    LBStructInterface(ExecMode m, const LBFullSymbol& name);
    ~LBStructInterface();

    const LBPropertyInfo* propertyInfo(int index, LBPropertyInfo::ExecAttr attr) const;
    const LBPropertyInfo* propertyInfo(const LBSymbol& name, int &index) const;
    int numberOfPropertiesByAttr(LBPropertyInfo::ExecAttr attr) const;
    ExecMode mode() const;
    const LBFullSymbol* name() const;

    string toString() const;
    ostream& toStream(ostream& ost) const
    {
      // to be done
      throw LBException("Not implemented yet");
    }

    istream& fromStream(istream& ist)
    {
      // to be done
      throw LBException("Not implemented yet");
    }

    bool hasInterface(const LBFullSymbol& structname) const; // interface inheritance checking

    // functions used by symbol reoslver
    int numOfParents() const; // number of interfaces inherited
    bool parentsUnresolved() const;
    const LBFullSymbol* parentName(int index) const;
    bool setParentInterface(int index, const LBStructInterface& pf, string& errs, bool forcereset = false); // merge the definition of parent interface

    bool addProperty( LBPropertyInfo *p, string& errs); // return false if error
    void addParent( const LBFullSymbol& pname );

    const LBFullSymbolVec *externalSymbols() const
    { return _extsymbols; }
    bool resolveAllPropertyTypes(string& errs);

    
    // policy definition
    static bool allowInitProcess( ExecMode m, LBPropertyInfo::ExecAttr);

  private:
    LBStructInterface& operator=(const LBStructInterface& i);

  private:

    ExecMode _mode;
    LBFullSymbol _name;

    typedef std::vector<LBPropertyInfo*> PropertyInfoVec;
    PropertyInfoVec *_ins;
    PropertyInfoVec *_outs;
    PropertyInfoVec *_stores;
    PropertyInfoVec *_statics;

    struct PropertyInfoIndex
    {
      PropertyInfoIndex()
	: _pinfo(0), _index(-1), _parentindex(-1)
      {}
      
      PropertyInfoIndex(const LBPropertyInfo *pinfo, int idx, int parentidx = -1)
	: _pinfo(pinfo), _index(idx), _parentindex(parentidx)
      {}
      const LBPropertyInfo *_pinfo;
      int _index;
      int _parentindex;
    };

    typedef LBHashMap<LBSymbol, PropertyInfoIndex> PropertyMap;
    PropertyMap *_pmap;

    struct ParentInfo
    {
      ParentInfo(const LBFullSymbol pname)
	: _parentname(pname), _resolved(false)
      {}
      LBFullSymbol _parentname;
      bool _resolved;
    };

    typedef std::vector<ParentInfo> ParentInfoVec;
    ParentInfoVec *_parents;

    typedef LBHashSet<LBFullSymbol> AncestorSet;
    AncestorSet *_ancestors;
    
    LBFullSymbolVec *_extsymbols;

    int _parentsresolved;

  private: // private helper functions
    PropertyInfoVec *ins();
    PropertyInfoVec *outs();
    PropertyInfoVec *stores();
    PropertyInfoVec *statics();
    AncestorSet *ancestors();
    LBFullSymbolVec *extsymbols(); 
    ParentInfoVec *parents();
    PropertyMap *pmap();

    
  };

}

#endif
